// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file audio.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Audio interface class
 */

#ifndef NV_AUDIO_HH
#define NV_AUDIO_HH

#include <nv/core/common.hh>
#include <nv/stl/math.hh>
#include <nv/stl/handle.hh>

namespace nv
{

	struct sound_tag {};
	struct channel_tag {};
	typedef handle< uint32, 16, 16, sound_tag >       sound;
	typedef handle< uint32, 16, 16, channel_tag >     channel;
	
	class audio
	{
	public:
		virtual channel play_sound( sound a_sound, float volume = 1.0f, float pan = 0.0f ) = 0;
		virtual channel play_sound( sound a_sound, vec3 position ) = 0;
		// temporary - use streams later
		virtual sound load_sound( const std::string& a_path ) = 0;
		virtual void release( sound a_sound ) = 0;
		virtual void set_orientation( vec3 forward, vec3 up ) = 0;
		virtual void update( vec3 ) {}
		virtual ~audio() {}
	};
}

#endif // NV_AUDIO_HH
