// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file gui_element.hh
 * @author Kornel Kisielewicz
 * @brief GUI Element
 */

#ifndef NV_GUI_ELEMENT_HH
#define NV_GUI_ELEMENT_HH

#include <nv/core/common.hh>
#include <nv/core/position.hh>
#include <nv/core/io_event.hh>
#include <nv/stl/string.hh>
#include <nv/gui/gui_common.hh>
#include <list>

namespace nv
{
	namespace gui
	{

		class element
		{
		public:
			/// List type
			typedef std::list<handle> list;

			string    m_id;              ///< id type of the object
			handle    m_parent;          ///< pointer to parent
			flags     m_flags;
			list      m_children;        ///< children objects
			size_t    m_child_count;     ///< number of children
			string    m_class; ///< Class name.
			string    m_text; ///< Displayed label or text.
			rectangle m_relative; ///< Position relative to parent.
			rectangle m_absolute; ///< Position relative to window/screen.
			render_data* m_render_data; ///<   -?-
		};

	} // namespace gui

} // namespace nv

#endif // NV_GUI_ELEMENT_HH
