// Copyright (C) 2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/engine/program_manager.hh"
#include "nv/core/range.hh"
#include "nv/core/logging.hh"
#include "nv/lua/lua_nova.hh"


nv::program_manager::program_manager( context* a_context ) : m_context( a_context )
{
	m_vertex_head   = a_context->get_device()->get_shader_header();
	m_fragment_head = a_context->get_device()->get_shader_header();
}

nv::resource_id nv::program_manager::load_resource( lua::table_guard& table )
{
	NV_LOG_DEBUG( table.get_string("id") );
	std::string vsource;
	std::string fsource;
	std::string csource;
	if ( table.is_table("common") )
	{
		lua::table_guard common( table, "common" );
		load_source( common, csource, "" );
	}
	{
		lua::table_guard vtable( table, "vertex" );
		load_source( vtable, vsource, m_vertex_head+"\n"+csource+"\n");
	}
	{
		lua::table_guard ftable( table, "fragment" );
		load_source( ftable, fsource, m_fragment_head+"\n"+csource+"\n" );
	}

	nv::program program = m_context->get_device()->create_program( vsource, fsource );
	return add( program );
}

void nv::program_manager::release( program p )
{
	m_context->get_device()->release( p );
}

void nv::program_manager::load_source( lua::table_guard& table, string& out, const string& append )
{
	out = append;
	if ( table.is_string( "files" ) )
	{
		out += nv::slurp( table.get_std_string( "files" ) );
	}
	else if ( table.is_table( "files" ) )
	{
		lua::table_guard inctable( table, "files" );
		uint32 count = inctable.get_size();
		for ( uint32 i = 1; i <= count; ++i )
		{
			std::string include( inctable.get<std::string,uint32>(i) );
			if ( i == count ) out += "#line 1\n";
			out += nv::slurp( include );
		}
	}

	if ( table.is_string( "file" ) )
	{
		out += "#line 1\n" + nv::slurp( table.get_std_string( "file" ) );
	}

	if ( table.is_string( "source" ) )
	{
		out += table.get_std_string( "source" );
	}
}
