// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gui/gui_style.hh"

#include <nv/lua/lua_raw.hh>

using namespace nv;
using namespace nv::gui;

style::style()
{
}

void style::load_style( const std::string& filename )
{
	m_lua.do_file( filename );
}

bool style::get( element* e, const char* centry, const char* cselector, std::string& s )
{
	lua::stack_guard guard( m_lua );
	if ( !resolve( e->m_id.c_str(), e->m_class.c_str(), cselector, centry, LUA_TSTRING ) ) return false;
	s = lua_tostring( m_lua, -1 );
	return true;
}

bool style::get( element* e, const char* centry, const char* cselector, vec4& vec )
{
	lua::stack_guard guard( m_lua );
	if ( !resolve( e->m_id.c_str(), e->m_class.c_str(), cselector, centry, LUA_TTABLE ) ) return false;
	vec = vec4();
	for (size_t i = 0; i < 4; ++i )
	{
		lua_rawgeti( m_lua, -1, static_cast<int>( i+1 ) );
		if ( lua_isnil( m_lua, -1 ) ) return true;
		vec[i] = (float)lua_tonumber( m_lua, -1 );
		lua_pop( m_lua, 1 );
	}
	return true;
}

bool style::get( element* e, const char* centry, const char* cselector, int& i )
{
	lua::stack_guard guard( m_lua );
	if ( !resolve( e->m_id.c_str(), e->m_class.c_str(), cselector, centry, LUA_TNUMBER ) ) return false;
	i = static_cast< int >( lua_tointeger( m_lua, -1 ) );
	return true;
}

bool style::get( element* e, const char* centry, const char* cselector, double& d )
{
	lua::stack_guard guard( m_lua );
	if ( !resolve( e->m_id.c_str(), e->m_class.c_str(), cselector, centry, LUA_TNUMBER ) ) return false;
	d = lua_tonumber( m_lua, -1 );
	return true;
}

style::~style()
{
}

bool style::find_entry( const char* cselector, const char* centry, int type )
{
	if ( lua_istable( m_lua, -1 ) )
	{
		if ( cselector )
		{
			lua_getfield( m_lua, -1, cselector );
			if ( lua_istable( m_lua, -1 ) )
			{
				lua_getfield( m_lua, -1, centry );
				if ( lua_type( m_lua, -1 ) == type ) 
				{
					return true;
				}
				lua_pop( m_lua, 1 );
			}
			lua_pop( m_lua, 1 );
		}

		lua_getfield( m_lua, -1, centry );
		if ( lua_type( m_lua, -1 ) == type ) return true;
	}
	return false;
}

bool style::resolve( const char* cid, const char* cclass, const char* cselector, const char* centry, int type )
{
	lua_getglobal( m_lua, "default" );
	int global = lua_gettop( m_lua );

	// check id
	lua_getfield( m_lua, -1, cid );
	if ( find_entry( cselector, centry, type ) ) return true;
	lua_settop( m_lua, global );

	// check class
	lua_getfield( m_lua, -1, cclass );
	if ( find_entry( cselector, centry, type ) ) return true;
	lua_settop( m_lua, global );

	// check entry
	if ( find_entry( cselector, centry, type ) ) return true;
	return false;
}
