// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file gui_common.hh
 * @author Kornel Kisielewicz
 * @brief common GUI
 */

#ifndef NV_GUI_COMMON_HH
#define NV_GUI_COMMON_HH

#include <nv/core/common.hh>
#include <nv/core/handle.hh>
#include <nv/core/flags.hh>

namespace nv
{
	namespace gui
	{
		enum flag
		{
			ENABLED,  //!< GUI element accepts events
			VISIBLE,  //!< GUI element visible
			DIRTY,    //!< GUI element needs redraw
			SELECTED, //!< GUI element selected
			HOVER,    //!< GUI element in hover zone
		};

		enum alignment
		{
			ALIGN_TOP,
			ALIGN_BOTTOM,
			ALIGN_CENTER,
			ALIGN_SCALE,
			ALIGN_LEFT = ALIGN_TOP,
			ALIGN_RIGHT = ALIGN_BOTTOM,
		};

		class render_data
		{
		public:
			virtual ~render_data(){}
		};

		class element;
		class environment;
		class renderer;

		typedef nv::handle<> handle;

		typedef nv::flags< 32, flag > flags;

	} // namespace gui

} // namespace nv

#endif // NV_GUI_ELEMENT_HH
