// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
#ifndef NV_LUA_FLAGS_HH
#define NV_LUA_FLAGS_HH

#include <nv/core/common.hh>
#include <nv/core/flags.hh>
#include <nv/lua/lua_state.hh>
#include <nv/lua/lua_values.hh>

namespace nv
{
	namespace lua
	{
//		void register_flags( lua_State* L );

		namespace detail
		{
			void read_flags( lua_State* L, int index, uint8* data, uint32 count );
			void push_flags( lua_State* L, uint8* data, uint32 count );

			template< uint32 SIZE, typename T >
			void push_flags( lua_State* L, const flags<SIZE,T>& f ) 
			{ 
				push_flags( L, f.data(), f.size() );
			}

			template< uint32 SIZE, typename T >
			flags<SIZE,T> to_flags( lua_State* L, int index ) 
			{ 
				flags<SIZE,T> result;
				read_flags( L, index, result.data(), result.size() );
				return result;
			}

			template< uint32 SIZE, typename T >
			void read_flags( lua_State* L, int index, flags<SIZE,T>& flags ) 
			{ 
				read_flags( L, index, flags.data(), flags.size() );
			}

		}

		template< uint32 SIZE, typename T >
		struct pass_traits< flags< SIZE, T > >
		{
			typedef flags< SIZE, T > value_type;
			static void push( lua_State *L, const flags< SIZE, T >& f ) { detail::push_flags( L, f ); }
			static value_type to( lua_State *L, int index ) { return detail::to_flags< SIZE, T >( L, index ); }
		};

	}
}

#endif // NV_LUA_FLAGS_HH
