// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file device.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Device class
 */

#ifndef NV_DEVICE_HH
#define NV_DEVICE_HH

#include <nv/common.hh>
#include <nv/string.hh>

namespace nv
{
	class window;
	class program;

	class device
	{
	public:
		virtual window* create_window( uint16 width, uint16 height ) = 0;
		virtual program* create_program( const string& vs_source, const string& fs_source, const string& gs_source = "" ) = 0;
	};

} // namespace nv


#endif // NV_DEVICE_HH
