// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_LUA_PATH_HH
#define NV_LUA_PATH_HH

#include <nv/core/common.hh>
#include <nv/core/string.hh>
#include <cstring>

struct lua_State;

namespace nv
{
	namespace lua
	{

		class path
		{
			struct element 
			{
				size_t value;
				size_t length;
				element() : value( 0 ), length( 0 ) {}
			};


		public:
			path( nv::string p );
			path( const char* p );
			path( unsigned i );

			template < typename T1, typename T2 >
			path( const T1& p1, const T2& p2 ) : m_count( 0 )
			{
				const size_t l1 = string_length<T1>::get( p1 );
				const size_t l2 = string_length<T2>::get( p2 );
				m_path.reserve( l1 + l2 + 1 );
				push( p1, l1 );
				push( p2, l2 );
			}

			template < typename T1, typename T2, typename T3 >
			path( const T1& p1, const T2& p2, const T3& p3 ) : m_count( 0 )
			{
				const size_t l1 = string_length<T1>::get( p1 );
				const size_t l2 = string_length<T2>::get( p2 );
				const size_t l3 = string_length<T3>::get( p3 );
				m_path.reserve( l1 + l2 + l3 + 1 );
				push( p1, l1 );
				push( p2, l2 );
				push( p3, l3 );
			}

			template < typename T1, typename T2, typename T3, typename T4 >
			path( const T1& p1, const T2& p2, const T3& p3, const T4& p4 ) : m_count( 0 )
			{
				const size_t l1 = string_length<T1>::get( p1 );
				const size_t l2 = string_length<T2>::get( p2 );
				const size_t l3 = string_length<T3>::get( p3 );
				const size_t l4 = string_length<T4>::get( p4 );
				m_path.reserve( l1 + l2 + l3 + l4 + 1 );
				push( p1, l1 );
				push( p2, l2 );
				push( p3, l3 );
				push( p4, l4 );
			}

			template < typename T1, typename T2, typename T3, typename T4, typename T5 >
			path( const T1& p1, const T2& p2, const T3& p3, const T4& p4, const T5& p5 ) : m_count( 0 )
			{
				const size_t l1 = string_length<T1>::get( p1 );
				const size_t l2 = string_length<T2>::get( p2 );
				const size_t l3 = string_length<T3>::get( p3 );
				const size_t l4 = string_length<T4>::get( p4 );
				const size_t l5 = string_length<T5>::get( p5 );
				m_path.reserve( l1 + l2 + l3 + l4 + l5 + 1 );
				push( p1, l1 );
				push( p2, l2 );
				push( p3, l3 );
				push( p4, l4 );
				push( p4, l5 );
			}

			std::string to_string() const;
			bool resolve( lua_State* L, bool global = true ) const;
		private:

			void parse();
			void push( size_t start, size_t length );
			void push( size_t e );
			void push( const nv::string& p, size_t lenght );
			void push( const char* s, size_t length );
		private:
			element     m_elements[8];
			sint32      m_count;
			std::string m_path;
		};

	} // namespace lua

} // namespace nv

#endif // NV_LUA_PATH_HH
