// Copyright (C) 2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file window_manager.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Window Manager interface
 */

#ifndef NV_WINDOW_MANAGER_HH
#define NV_WINDOW_MANAGER_HH

#include <nv/core/common.hh>
#include <nv/core/string.hh>

namespace nv
{
	class context;
	class device;
	class window;
	class image_data;

	class window_manager
	{
	public:
		virtual window* create_window( device* dev, uint16 width, uint16 height, bool fullscreen ) = 0;
		virtual void* adopt_window( void* sys_w_handle ) = 0;
		virtual void sleep( uint32 ms ) = 0;
		virtual uint32 get_ticks() = 0;
	};

}

#endif // NV_WINDOW_MANAGER_HH
