// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_LUA_FUNCTION_HH
#define NV_LUA_FUNCTION_HH

#include <nv/core/common.hh>
#include <nv/core/string.hh>
#include <nv/lua/lua_values.hh>
#include <nv/lua/lua_path.hh>

namespace nv
{
	namespace lua
	{

		class state;

		class function_base
		{
		public:
			function_base( lua_State* a_L, const path& a_path, bool a_global = true );
			function_base( const function_base& func );
			function_base& operator=( const function_base& func );
			~function_base();
		protected:
			void retrieve();
			void call( int args, int results );

		protected:
			int m_ref;
			lua_State* L;
		};

		template < typename R >
		class function : public function_base
		{
		public:
			function( lua_State *a_L, const path& a_path, bool a_global = true )
				: function_base( a_L, a_path, a_global )
			{
			}

			R operator()()
			{
				retrieve();
				return call_result<R>(0);
			}

			template <typename T1>
			R operator()( const T1& p1 )
			{
				retrieve();
				detail::push_value( L, p1 );
				return call_result<R>(1);
			}

			template <typename T1, typename T2>
			R operator()(const T1& p1, const T2& p2)
			{
				retrieve();
				detail::push_values( L, p1, p2 );
				return call_result<R>(2);
			}

			template <typename T1, typename T2, typename T3>
			R operator()(const T1& p1, const T2& p2, const T3& p3)
			{
				retrieve();
				detail::push_values( L, p1, p2, p3 );
				return call_result<R>(3);
			}
		protected:
			template< typename RR >
			R call_result( int params )
			{
				call( params, 1 );
				R value;
				detail::pop_value( L, value );
				return value;
			}
		};
 
		// I actually wonder whether this hack will work everywhere
 		template<>
 		template<>
 		inline void function<void>::call_result<void>( int params )
 		{
 			call( params, 0 );
 		}

	} // namespace lua

} // namespace nv

#endif // NV_LUA_HH