// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/lua/lua_flags.hh"

#include "nv/lua/lua_raw.hh"
#include "nv/core/string.hh"


void nv::lua::detail::read_flags( lua_State* L, int index, uint8* data, uint32 count )
{
	nlua_toflags( L, index, data, count );
}

void nv::lua::detail::push_flags( lua_State* L, uint8* data, uint32 count )
{
	// TODO : this can be optimized
	lua_createtable( L, 0, 0 );
	for ( int c = 0; c < static_cast< int >( count ); ++c )
	{
		int idx = c / 8;
		int pos = c % 8;
		if ( ( data[ idx ] & ( 1 << static_cast< uint8 >( pos ) ) ) != 0 )
		{
			lua_pushboolean( L, true );
			lua_rawseti( L, -2, c );
		}
	}
}
