// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file lua_map_area.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 */

#ifndef NV_LUA_MAP_AREA_HH
#define NV_LUA_MAP_AREA_HH

#include <nv/interface/map_area.hh>
#include <nv/lua/lua_state.hh>

namespace nv
{
	namespace lua
	{
		void register_map_area( lua_State* L );
		void register_map_area_interface( lua_State* L, int index );
		void register_map_area_instance( lua_State* L, ref object_index, map_area* area );

		namespace detail
		{
			bool is_map_area( lua_State* L, int index );
			map_area* to_map_area( lua_State* L, int index );
			void push_map_area( lua_State* L, map_area* c );
		}
	}
}

#endif // NV_LUA_MAP_AREA_HH
