// Copyright (C) 2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_LIB_CURSES_HH
#define NV_LIB_CURSES_HH

#include <nv/core/common.hh>

#define NV_CURSES_DYNAMIC
//#define NV_CURSES_SHARED

#if NV_PLATFORM == NV_WINDOWS
#	define NV_CURSES_PATH "pdcurses.dll"
#elif NV_PLATFORM == NV_APPLE
#	define NV_CURSES_PATH ""
#else
#	define NV_CURSES_PATH ""
#endif

extern "C" {

#if defined(NV_CURSES_SHARED) && (NV_PLATFORM == NV_WINDOWS)
#	define NV_CURSES_API __declspec(dllimport)
#else
#	define NV_CURSES_API extern
#endif

#include <stdarg.h>
#include <stddef.h>
#include <wchar.h>

#include <nv/lib/detail/curses_types.inc>

#if defined(NV_CURSES_DYNAMIC)
#	define NV_CURSES_FUN( rtype, fname, fparams ) NV_CURSES_API rtype ( *fname) fparams
#else
#	define NV_CURSES_FUN( rtype, fname, fparams ) NV_CURSES_API rtype fname fparams
#endif

#include <nv/lib/detail/curses_functions.inc>

#undef NV_CURSES_FUN
}

namespace nv {
	/* Dynamic load support */
#	if defined( NV_CURSES_DYNAMIC )
	bool load_curses_library( const char* path = NV_CURSES_PATH );
#	else
	inline bool load_curses_library( const char* path = "" ) { return true; }
#	endif
}

#endif // NV_LIB_CURSES_HH
