// Copyright (C) 2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file input.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief input interface
 */

#ifndef NV_INPUT_HH
#define NV_INPUT_HH

#include <nv/core/common.hh>
#include <nv/core/io_event.hh>

namespace nv
{

	class input
	{
	public:
		virtual bool is_event_pending() = 0;
		virtual bool poll_event( io_event& event ) = 0;
		virtual ~input() {};
	};

}

#endif // NV_INPUT_HH