// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file gui_style.hh
 * @author Kornel Kisielewicz
 * @brief GUI Styue
 */

#ifndef NV_GUI_STYLE_HH
#define NV_GUI_STYLE_HH

#include <nv/gui/gui_element.hh>
#include <nv/lua/lua_state.hh>

namespace nv
{

	namespace gui
	{

		class style
		{
		public:
			style();
			void load_style( const std::string& filename );
			bool get( element* e, const std::string& entry, std::string& s );
			bool get( element* e, const std::string& entry, vec4& vec );
			bool get( element* e, const std::string& entry, int& i );
			bool get( element* e, const std::string& entry, double& d );
			~style();
		protected:
			bool resolve( element* e, const std::string& entry, int type );
		protected:
			lua::state m_lua; //!< separate lua state for style calculation
		};

	} // namespace gui

} // namespace nv

#endif // NV_GUI_STYLE_HH
