// Copyright (C) 2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file curses_terminal.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief curses terminal interface
 */

#ifndef NV_CURSES_TERMINAL_HH
#define NV_CURSES_TERMINAL_HH

#include <nv/core/common.hh>
#include <nv/interface/terminal.hh>
#include <nv/core/io_event.hh>

namespace nv
{
	class curses_terminal : public terminal
	{
	public:	
		/**
		 * Constructor
		 */
		curses_terminal( dimension size );

        /**
         * Update the screen
         */
        virtual void update();

        /**
         * Print a character of the given color to the screen memory
         */
        virtual void print( position p, uint32 color, unsigned char ch );

        /**
		 * Clear screen memory
         */
        virtual void clear( rectangle r );

        /**
         * Clear screen memory
         */
        virtual void clear();

        /**
         * Polls event
         */
        virtual bool poll( io_event& kevent );

		/**
		 * Set cursor position
		 */
		virtual void set_cursor( position p );

		/**
		 * Show cursor
		 */
		virtual void show_cursor();

		/**
		 * Hide cursor
		 */
		virtual void hide_cursor();

	public: // other methods
		/**
		 * Virtual destructor
		 */
		virtual ~curses_terminal();

	protected:
		void* m_screen;
		bool  m_update_needed;
	};
}

#endif // NV_TERMINAL_HH
