#include <nv/gl/gl_device.hh>
#include <nv/gui/gui_environment.hh>
#include <nv/interface/context.hh>
#include <nv/core/logging.hh>
#include <nv/core/logger.hh>
#include <nv/core/random.hh>

class application
{
public:
	application();
	bool initialize();
	bool run();
	void kill_window();
	void spawn_window();
	void recolor_window();
//	void bring_to_front( int i );
	~application();
protected:
	nv::device* m_device;
	nv::window* m_window;
	nv::clear_state m_clear_state;
	nv::gui::environment* m_guienv;
	std::vector<nv::gui::handle>   m_windows;
};

application::application()
{
	m_device = new nv::gl_device();
	m_window = m_device->create_window( 800, 600, false );
	m_clear_state.buffers = nv::clear_state::COLOR_AND_DEPTH_BUFFER;
	m_guienv = new nv::gui::environment( m_window );
	m_guienv->load_style( "test.style.lua" );
}

bool application::initialize()
{
	return true;
}

bool application::run()
{
	int keypress = 0;

	while(!keypress) 
	{
		m_guienv->update();

		m_window->get_context()->clear( m_clear_state );
		m_guienv->draw();
		m_window->swap_buffers();

		nv::io_event event;
		while(m_window->poll_event(event)) 
		{      
			switch (event.type) 
			{
			case nv::EV_QUIT:
				keypress = 1;
				break;
			case nv::EV_KEY:
				if (event.key.pressed)
				{
					switch (event.key.code) 
					{
// 					case nv::KEY_1      : bring_to_front(0); break;
// 					case nv::KEY_2      : bring_to_front(1); break;
// 					case nv::KEY_3      : bring_to_front(2); break;
// 					case nv::KEY_4      : bring_to_front(3); break;
// 					case nv::KEY_5      : bring_to_front(4); break;
					case nv::KEY_N      : spawn_window(); break;
					case nv::KEY_K      : kill_window(); break;
					case nv::KEY_ESCAPE : keypress = 1; break;
					}
				}
				break;
			}
		}
	}
	return true;
}

void application::spawn_window()
{
	nv::ivec2 a = nv::random::get().range( nv::ivec2(), nv::ivec2( 600, 400 ) );
	nv::ivec2 b = nv::random::get().range( nv::ivec2( 40, 40 ), nv::ivec2( 240, 240 ) );
	nv::gui::handle e = m_guienv->create_element( nv::rectangle(a).dim(b) );
	m_guienv->set_class( e, "window" );
	m_guienv->set_text( e, "Window "+nv::to_string(m_windows.size()+1) );
	NV_LOG( nv::LOG_INFO, "Spawn (" << a.x << "," << a.y << "x" << b.x << "," << b.y << ")" );
	m_windows.push_back( e );
}

void application::kill_window()
{
	if ( m_windows.size() == 0 ) return;
	size_t index = nv::random::get().urand( m_windows.size() );
	m_guienv->destroy_element( m_windows[index] );
	m_windows.erase( m_windows.begin() + index );
}

application::~application()
{
	m_windows.clear();
	delete m_window;
	delete m_device;
}

// void application::bring_to_front( int i )
// {
// 	if ( i >= 0 && i < m_windows.size() )
// 	{
// 		m_guienv->bring_to_front( m_windows[i] );
// 	}
// }

int main(int, char* [])
{
	nv::random::get().randomize();
	nv::logger log(nv::LOG_TRACE);
	log.add_sink( new nv::log_file_sink("log.txt"), nv::LOG_TRACE );
	log.add_sink( new nv::log_console_sink(), nv::LOG_TRACE );
	
	NV_LOG( nv::LOG_NOTICE, "Logging started" );
	application app;
	if ( app.initialize() )
	{
		app.run();
	}
	NV_LOG( nv::LOG_NOTICE, "Logging stopped" );

	return 0;
}

