// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file gui_common.hh
 * @author Kornel Kisielewicz
 * @brief common GUI
 */

#ifndef NV_GUI_COMMON_HH
#define NV_GUI_COMMON_HH

#include <nv/core/common.hh>
#include <nv/core/handle.hh>

namespace nv
{
	namespace gui
	{
		enum alignment
		{
			ALIGN_TOP,
			ALIGN_BOTTOM,
			ALIGN_CENTER,
			ALIGN_SCALE,
			ALIGN_LEFT = ALIGN_TOP,
			ALIGN_RIGHT = ALIGN_BOTTOM,
		};

		class render_data
		{
		public:
			virtual ~render_data(){}
		};

		class element;
		class environment;
		class renderer;

		typedef nv::handle<> handle;

	} // namespace gui

} // namespace nv

#endif // NV_GUI_ELEMENT_HH
