// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/sdl/sdl_audio.hh"

#include "nv/lib/sdl.hh"
#include "nv/lib/sdl_mixer.hh"
#include "nv/core/logging.hh"

using namespace nv;

sdl::audio::audio()
{
	nv::load_sdl_library();
	nv::load_sdl_mixer_library();

	if ( SDL_Init( SDL_INIT_AUDIO ) == -1 ) 
	{
		NV_LOG( LOG_CRITICAL, "SDL_AUDIO failed to load -- " << SDL_GetError() );
		return;
	}

	if( Mix_OpenAudio( 44100, MIX_DEFAULT_FORMAT, 2, 1024 ) == -1 )
	{
		NV_LOG( LOG_CRITICAL, "SDL_mixer failed to load -- " << Mix_GetError() );
		return;
	}
}


nv::channel* sdl::audio::play_sound( nv::sound* a_sound )
{
	if ( Mix_PlayChannel(-1, (Mix_Chunk*)( down_cast< sdl::sound >( a_sound )->m_sound), 0) == -1 )
	{
		NV_LOG( LOG_WARNING, "SDL_mixer failed to play -- " << Mix_GetError() );
	}
	return nullptr;
}

nv::sound* nv::sdl::audio::load_sound( const std::string& a_path )
{
	Mix_Chunk *sample = Mix_LoadWAV( a_path.c_str() );
	if ( sample == nullptr )
	{
		NV_LOG( LOG_ERROR, "SDL_mixer failed to load sample '" << a_path << "' -- " << Mix_GetError() );
		return nullptr;
	}
	return new sdl::sound( sample );
}

void nv::sdl::audio::update()
{
	// no-op
}

nv::sdl::audio::~audio()
{
	Mix_CloseAudio();
	// TODO: should we do it here?
	SDL_Quit();
}

nv::sdl::sound::~sound()
{
	Mix_FreeChunk( (Mix_Chunk*)m_sound );
}
