// Copyright (C) 2014 ChaosForge Ltd 
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
//
// NOTE: this file is header only, not to have NV depend on WX
#ifndef NV_LIB_WX_HH
#define NV_LIB_WX_HH

#if defined( NV_COMMON_HH ) || defined( _WX_WX_H_ )
#error For proper side-by-side usage WX header needs to be included first!
#endif

#define __GL_H__
#include <stddef.h>
#include <nv/lib/detail/gl_types.inc>
#include "wx/wx.h"
#undef near
#undef far
#include <nv/core/common.hh>
#include <nv/lib/gl.hh>
#include <nv/gl/gl_device.hh>
#include <nv/interface/context.hh>
#include <nv/interface/window.hh>

namespace nv
{
	class gl_canvas : public wxWindow
	{
	public:
		explicit gl_canvas( wxWindow *parent );
		virtual void OnUpdate() = 0;
// 		virtual void Stop() { m_update_timer->Stop(); }
// 		virtual void Start() { m_update_timer->Start(20); }
		virtual void Stop() 
		{
			Disconnect( wxEVT_IDLE, wxIdleEventHandler(gl_canvas::OnIdle) );
			//m_update_timer->Stop();
		}
		virtual void Start() 
		{ 
			Connect( wxID_ANY, wxEVT_IDLE, wxIdleEventHandler(gl_canvas::OnIdle) );
			//m_update_timer->Start(20);
		}
		void OnIdle(wxIdleEvent& evt)
		{
			if(m_render)
			{
				OnUpdate();
				evt.RequestMore(); // render continuously, not only once on idle
			}
		}
		~gl_canvas();
	protected:
		void OnPaint( wxPaintEvent& event );

		nv::device*  m_device;
		nv::context* m_context;
		nv::window*  m_window;
		wxTimer*     m_update_timer;
		bool         m_render;
		wxDECLARE_EVENT_TABLE();
	};

	class gl_update_timer : public wxTimer
	{
	public:
		explicit gl_update_timer( gl_canvas* canvas )
			: wxTimer(), m_canvas( canvas ) {}
		virtual void Notify() { m_canvas->OnUpdate(); }
	private:
		gl_canvas* m_canvas;
	};

// 	wxBEGIN_EVENT_TABLE(gl_canvas, wxWindow)
// 		EVT_PAINT(gl_canvas::OnPaint)
// 	wxEND_EVENT_TABLE()

	inline gl_canvas::gl_canvas( wxWindow *parent )
		: wxWindow(parent, wxID_ANY, wxDefaultPosition, wxDefaultSize,
	wxFULL_REPAINT_ON_RESIZE)
	{
		nv::load_gl_no_context();
		wxClientDC dc(this);
		m_device = new nv::gl_device();
		m_window = m_device->adopt_window( GetHWND(), dc.GetHDC() );
		m_context = m_window->get_context();
	}

	inline gl_canvas::~gl_canvas()
	{
		delete m_window;
		delete m_device;
	}

	inline void gl_canvas::OnPaint( wxPaintEvent& )
	{
		const wxSize client_size = GetClientSize();
		m_context->set_viewport( nv::ivec4( nv::ivec2(), client_size.x, client_size.y ) );
		OnUpdate();
	}

}

#endif NV_LIB_WX_HH
