// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file mesh_loader.hh
 * @author Kornel Kisielewicz
 * @brief mesh loader
 */

#ifndef NV_OBJ_LOADER_HH
#define NV_OBJ_LOADER_HH

#include <nv/core/common.hh>
#include <nv/interface/mesh_loader.hh>
#include <nv/interface/mesh_data.hh>

namespace nv 
{

	class obj_loader : public mesh_loader
	{
	public:
		obj_loader( bool normals = true, bool tangents = false );
		virtual bool load( stream& source );
		virtual mesh_data* release_mesh_data( size_t index = 0 );
		virtual mesh_data_pack* release_mesh_data_pack();
		virtual size_t get_mesh_count() const { return m_meshes.size(); }
		~obj_loader();
	private:
		vertex_descriptor         m_descriptor;
		bool                      m_normals;
		bool                      m_tangents;
		std::vector< mesh_data* > m_meshes;
	};

}

#endif // NV_OBJ_LOADER_HH
