// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/lib/sdl_mixer.hh"

#if defined( NV_SDL_DYNAMIC )

#include "nv/library.hh"

#define NV_SDL_FUN( rtype, fname, fparams ) rtype (NV_SDL_APIENTRY *fname) fparams = nullptr;
#include <nv/lib/detail/sdl_mixer_functions.inc>
#undef NV_SDL_FUN

bool nv::load_sdl_mixer_library( const char* path )
{
	static nv::library sdl_mixer_library;
	if ( sdl_mixer_library.is_open() ) return true;
	sdl_mixer_library.open( path );

#	define NV_SDL_FUN( rtype, fname, fparams ) *(void **) (&fname) = sdl_mixer_library.get(#fname);
#	include <nv/lib/detail/sdl_mixer_functions.inc>
#	undef NV_SDL_FUN

	return true;
}
#endif
