// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_GL_FONT_HH
#define NV_GL_FONT_HH

#include <nv/common.hh>
#include <nv/math.hh>
#include <unordered_map>

namespace nv
{
	struct gylph
	{
	    uint16 charcode;
		ivec2 size;
	    ivec2 offset;
	    vec2 advance;
	    vec2 tl;
	    vec2 br;
		std::unordered_map< uint16, float > kerning;

		gylph();
		float get_kerning( const uint16 cc );
	};

	class font
	{
	public:
		const gylph* get_gylph( uint16 charcode ) const;
	private:
		std::unordered_map< uint16, gylph > m_gylphs;
	}


}

#endif // NV_GL_FONT_HH
