// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file gl_context.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Context class
 */

#ifndef NV_GL_CONTEXT_HH
#define NV_GL_CONTEXT_HH

#include <nv/interface/context.hh>

namespace nv
{
	struct gl_framebuffer_info : public framebuffer_info
	{
		unsigned glid;
	};

	class gl_context : public context
	{
	protected:
		gl_context( device* a_device );
	public:
		~gl_context();

		virtual vertex_array create_vertex_array();
		virtual framebuffer create_framebuffer();
		virtual void release( vertex_array va );
		virtual void release( framebuffer f );
		virtual const vertex_array_info* get_vertex_array_info( vertex_array va ) const;
		virtual const framebuffer_info* get_framebuffer_info( framebuffer f ) const;

		virtual void bind( texture t, texture_slot slot );

		virtual void update( texture t, void* data );
		virtual void update( buffer b, const void* data, size_t offset, size_t size );

		virtual void clear( const clear_state& cs );
		// temporary
		virtual void draw( primitive prim, const render_state& rs, program p, vertex_array va, size_t count );
		virtual const ivec4& get_viewport();
		virtual void set_viewport( const ivec4& viewport );
		virtual void apply_render_state( const render_state& state );
		virtual void apply_engine_uniforms( program p, const scene_state& s );

	protected:
		void bind( program p );
//		void bind( buffer b );
		void bind( vertex_array va );
		void bind( framebuffer va );
		void unbind( program p );
//		void unbind( buffer b );
		void unbind( vertex_array va );
		void unbind( framebuffer va );

		void force_apply_render_state( const render_state& state );
		void force_apply_stencil_face( unsigned face, const stencil_test_face& stencil );
		// TODO: remove
		virtual vertex_array_info* get_vertex_array_info_mutable( vertex_array );
	private:
		void apply_stencil_test( const stencil_test& stencil );
		void apply_stencil_face( unsigned face, stencil_test_face& stencil, const stencil_test_face& new_stencil );
		void apply_scissor_test( const scissor_test& scissor );
		void apply_depth_test( const depth_test& depth );
		void apply_depth_mask( bool mask );
		void apply_depth_range( const depth_range& range );
		void apply_color_mask( const color_mask& mask );
		void apply_blending( const blending& blend );
		void apply_culling( const culling& cull );
		void apply_polygon_mode( const polygon_mode& mode );
		void enable( unsigned int what, bool value );
	private:
		vec4  m_clear_color;
		float m_clear_depth;
		int   m_clear_stencil;

		entity_store< vertex_array_info, vertex_array >  m_vertex_arrays;
		entity_store< gl_framebuffer_info, framebuffer > m_framebuffers;
	};

	class sdl_gl_context : public gl_context
	{
	public:
		sdl_gl_context( device* a_device, void* a_sdl_win_handle );
		~sdl_gl_context();
	private:
		void* m_handle;
	};

	class native_gl_context : public gl_context
	{
	public:
		native_gl_context( device* a_device, void* a_native_win_handle );
		void* get_native_handle() { return m_handle; }
		~native_gl_context();
	private:
		void* m_handle;
	};


} // namespace nv

#endif // NV_CONTEXT_HH
