// Copyright (C) 2014 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_DEBUG_DRAW_HH
#define NV_DEBUG_DRAW_HH

#include <nv/common.hh>
#include <nv/math.hh>
#include <nv/interface/context.hh>

namespace nv
{
	struct debug_vtx
	{
		vec3 position;
		vec3 color;

		debug_vtx( const vec3& v, const vec3& c )
			: position(v), color( c ) {}
	};

	class debug_data
	{
	public:
		debug_data( device* a_device );
		void update();
		void reset();
		program       get_program()      { return m_program; }
		vertex_array  get_vertex_array() { return m_va; }
		uint32        get_count()        { return m_data.size(); }

		void push_line( const vec3& a, const vec3& b, const vec3& color );
		void push_aabox( const vec3& a, const vec3& b, const vec3& color );
		~debug_data();
	private:
		device*                  m_device;
		program                  m_program;
		vertex_array             m_va;
		std::vector< debug_vtx > m_data;
	};

}

#endif // NV_DEBUG_DRAW_HH
