// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/uid.hh"

using namespace nv;

uid_store_raw::uid_store_raw()
	: m_map(), m_current(0)
{
	
}

void* uid_store_raw::get( uid auid ) const
{
	map::const_iterator i = m_map.find( auid );
	if ( i != m_map.end() )
	{
		return i->second;
	}
	return nullptr;
}

bool uid_store_raw::remove( uid auid )
{
	return m_map.erase( auid ) != 0;
}

void uid_store_raw::insert( void* o, uid auid )
{
	m_map[ auid ] = o;
}

uid uid_store_raw::insert( void* o )
{
	uid u = request_uid();
	m_map[ u ] = o;
	return u;
}

uid uid_store_raw::request_uid()
{
	return ++m_current;
}

uid_store_raw::~uid_store_raw()
{
	// no-op
}
