// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file c_stream.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief stream implementation via c f* functions
 */

#ifndef NV_C_STREAM_HH
#define NV_C_STREAM_HH

#include <nv/common.hh>
#include <nv/interface/stream.hh>

namespace nv
{
	class c_file_system;

	class c_stream : public stream
	{
		friend class c_file_system;
	protected:
		c_stream();
		c_stream( void* pfile, const char* filename );
	public:
		virtual ~c_stream();
		virtual size_t read( void* buffer, size_t size, size_t count );
		virtual size_t write( const void* buffer, size_t size, size_t count );
		virtual bool seek( long offset, origin orig );
		virtual size_t tell();
		virtual size_t size();
		virtual void flush();
	private:
		void*       m_file;      //!< FILE* structure, masked
		const char* m_file_name; //!< File name
		size_t      m_file_size; //!< Cached file size
	};

} // namespace nv

#endif // NV_C_STREAM_HH
