// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/lib/freetype2.hh"

#if defined( NV_FREETYPE_DYNAMIC )

#include "nv/library.hh"

#define NV_FREETYPE_FUN( rtype, fname, fparams ) rtype (*fname) fparams = nullptr;
#include <nv/lib/detail/freetype2_functions.inc>
#undef NV_FREETYPE_FUN

bool nv::load_freetype_library( const char* path )
{
	static nv::library freetype_library;
	if ( freetype_library.is_open() ) return true;
	freetype_library.open( path );

#	define NV_FREETYPE_FUN( rtype, fname, fparams ) *(void **) (&fname) = freetype_library.get(#fname);
#	include <nv/lib/detail/freetype2_functions.inc>
#	undef NV_FREETYPE_FUN
	return true;
}
#endif
