// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file sdl_audio.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief SDL Audio interface 
 */

#ifndef NV_SDL_AUDIO_HH
#define NV_SDL_AUDIO_HH

#include <nv/common.hh>
#include <nv/interface/audio.hh>

namespace nv
{

	namespace sdl
	{
		class audio;

		class sound : public nv::sound
		{
		private:
			friend class nv::sdl::audio;
			sound( void* data ) : m_sound( data ) {}
		public:
			virtual ~sound();
		private:
			void* m_sound;
		};

		class channel : public nv::channel
		{
		private:
			friend class nv::sdl::audio;
			virtual ~channel() {}
		};

		class audio : public nv::audio
		{
		public:
			audio();
			virtual nv::channel* play_sound( nv::sound* a_sound );
			virtual nv::sound* load_sound( const std::string& a_path );
			virtual void update();
			virtual ~audio();
		};
	}
}

#endif // NV_SDL_AUDIO_HH
