// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/rogue/fov_recursive_shadowcasting.hh"

#include <nv/math.hh>

static int nv_rogue_rs_mult[4][8] = {
	{ 1, 0, 0,-1,-1, 0, 0, 1},
	{ 0, 1,-1, 0, 0,-1, 1, 0},
	{ 0, 1, 1, 0, 0,-1,-1, 0},
	{ 1, 0, 0, 1,-1, 0, 0,-1},
};

void nv::rogue::fov_recursive_shadowcasting::run( const position& p, uint16 radius )
{
	m_position = p;
	m_radius   = radius;

	if ( m_radius == 0 )
	{
		position max_radius = m_size-m_position;
		max_radius.x=glm::max(max_radius.x,m_position.x);
		max_radius.y=glm::max(max_radius.y,m_position.y);
		m_radius = (int)glm::length((glm::vec2)max_radius)+1;
	}
	m_radius2 = m_radius * m_radius;
	for ( int oct=0; oct < 8; oct++ ) cast_light( 1, 1.0, 0.0, oct );
	m_map->set_visible( p, true );
}

void nv::rogue::fov_recursive_shadowcasting::cast_light( int row, float start, float end, int oct )
{
	if ( start < end ) return;

	int xx = nv_rogue_rs_mult[0][oct];
	int xy = nv_rogue_rs_mult[1][oct];
	int yx = nv_rogue_rs_mult[2][oct];
	int yy = nv_rogue_rs_mult[3][oct];

	float new_start = 0.0f;
	for ( int j = row; j < m_radius + 1; j++ )
	{
		int dx=-j-1;
		int dy=-j;
		bool blocked = false;
		while ( dx++ <= 0 )
		{
			ivec2 c( dx*xx+dy*xy, dx*yx+dy*yy );
			c += m_position;
			if ( c.x >= 0 && c.x < m_size.x && c.y >= 0 && c.y < m_size.y )
			{
				float l_slope = ( dx - 0.5f ) / ( dy + 0.5f );
				float r_slope = ( dx + 0.5f ) / ( dy - 0.5f );
				if ( start < r_slope ) continue;
				if ( end   > l_slope ) break;
				bool transparent = m_map->is_transparent( c );

				if ( dx*dx+dy*dy <= m_radius2 && (m_light_walls || transparent)) 
				{
					m_map->set_visible( c, true );
				}
				if ( blocked )
				{
					if ( !transparent )
					{
						new_start = r_slope;
						continue;
					}
					blocked = false;
					start = new_start;
				}
				else
				{
					if ( !transparent && j < m_radius )
					{
						blocked = true;
						cast_light( j+1, start, l_slope, oct );
						new_start = r_slope;
					}
				}
			}
		}
		if ( blocked ) break;
	}

}

