// Copyright (C) 2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
//
// TODO : get rid of per-cell virtual calls

#ifndef NV_ROGUE_FOV_HH
#define NV_ROGUE_FOV_HH

#include <nv/common.hh>
#include <nv/position.hh>

namespace nv
{

	namespace rogue
	{

		class fov_interface
		{
		public:
			virtual void set_visible( const position& p, bool visible ) = 0;
			virtual bool is_visible( const position& p ) const = 0;
			virtual bool is_transparent( const position& p ) const = 0;
		};

		class fov_algorithm
		{
		public:
			virtual void initialize( fov_interface*, const dimension& size ) = 0;
			virtual void run( const position& p, uint16 radius ) = 0;

		};

	}

}

#endif // NV_ROGUE_FOV_HH
