/* SDL_video.h defines */
NV_SDL_FUN( int , SDL_GetNumVideoDrivers, (void) );
NV_SDL_FUN( const char *, SDL_GetVideoDriver, (int index) );
NV_SDL_FUN( int , SDL_VideoInit, (const char *driver_name) );
NV_SDL_FUN( void , SDL_VideoQuit, (void) );
NV_SDL_FUN( const char *, SDL_GetCurrentVideoDriver, (void) );
NV_SDL_FUN( int , SDL_GetNumVideoDisplays, (void) );
NV_SDL_FUN( const char * , SDL_GetDisplayName, (int displayIndex) );
NV_SDL_FUN( int , SDL_GetDisplayBounds, (int displayIndex, SDL_Rect * rect) );
NV_SDL_FUN( int , SDL_GetNumDisplayModes, (int displayIndex) );
NV_SDL_FUN( int , SDL_GetDisplayMode, (int displayIndex, int modeIndex,SDL_DisplayMode * mode) );
NV_SDL_FUN( int , SDL_GetDesktopDisplayMode, (int displayIndex, SDL_DisplayMode * mode) );
NV_SDL_FUN( int , SDL_GetCurrentDisplayMode, (int displayIndex, SDL_DisplayMode * mode) );
NV_SDL_FUN( SDL_DisplayMode * , SDL_GetClosestDisplayMode, (int displayIndex, const SDL_DisplayMode * mode, SDL_DisplayMode * closest) );
NV_SDL_FUN( int , SDL_GetWindowDisplayIndex, (SDL_Window * window) );
NV_SDL_FUN( int , SDL_SetWindowDisplayMode, (SDL_Window * window,const SDL_DisplayMode* mode) );
NV_SDL_FUN( int , SDL_GetWindowDisplayMode, (SDL_Window * window,SDL_DisplayMode * mode) );
NV_SDL_FUN( Uint32 , SDL_GetWindowPixelFormat, (SDL_Window * window) );
NV_SDL_FUN( SDL_Window * , SDL_CreateWindow, (const char *title,int x, int y, int w,int h, Uint32 flags) );
NV_SDL_FUN( SDL_Window * , SDL_CreateWindowFrom, (const void *data) );
NV_SDL_FUN( Uint32 , SDL_GetWindowID, (SDL_Window * window) );
NV_SDL_FUN( SDL_Window * , SDL_GetWindowFromID, (Uint32 id) );
NV_SDL_FUN( Uint32 , SDL_GetWindowFlags, (SDL_Window * window) );
NV_SDL_FUN( void , SDL_SetWindowTitle, (SDL_Window * window,const char *title) );
NV_SDL_FUN( const char *, SDL_GetWindowTitle, (SDL_Window * window) );
NV_SDL_FUN( void , SDL_SetWindowIcon, (SDL_Window * window,SDL_Surface * icon) );
NV_SDL_FUN( void* , SDL_SetWindowData, (SDL_Window * window,const char *name,void *userdata) );
NV_SDL_FUN( void *, SDL_GetWindowData, (SDL_Window * window,const char *name) );
NV_SDL_FUN( void , SDL_SetWindowPosition, (SDL_Window * window,int x, int y) );
NV_SDL_FUN( void , SDL_GetWindowPosition, (SDL_Window * window,int *x, int *y) );
NV_SDL_FUN( void , SDL_SetWindowSize, (SDL_Window * window, int w,int h) );
NV_SDL_FUN( void , SDL_GetWindowSize, (SDL_Window * window, int *w,int *h) );
NV_SDL_FUN( void , SDL_SetWindowMinimumSize, (SDL_Window * window,int min_w, int min_h) );
NV_SDL_FUN( void , SDL_GetWindowMinimumSize, (SDL_Window * window,int *w, int *h) );
NV_SDL_FUN( void , SDL_SetWindowMaximumSize, (SDL_Window * window,int max_w, int max_h) );
NV_SDL_FUN( void , SDL_GetWindowMaximumSize, (SDL_Window * window,int *w, int *h) );
NV_SDL_FUN( void , SDL_SetWindowBordered, (SDL_Window * window,SDL_bool bordered) );
NV_SDL_FUN( void , SDL_ShowWindow, (SDL_Window * window) );
NV_SDL_FUN( void , SDL_HideWindow, (SDL_Window * window) );
NV_SDL_FUN( void , SDL_RaiseWindow, (SDL_Window * window) );
NV_SDL_FUN( void , SDL_MaximizeWindow, (SDL_Window * window) );
NV_SDL_FUN( void , SDL_MinimizeWindow, (SDL_Window * window) );
NV_SDL_FUN( void , SDL_RestoreWindow, (SDL_Window * window) );
NV_SDL_FUN( int , SDL_SetWindowFullscreen, (SDL_Window * window,Uint32 flags) );
NV_SDL_FUN( SDL_Surface * , SDL_GetWindowSurface, (SDL_Window * window) );
NV_SDL_FUN( int , SDL_UpdateWindowSurface, (SDL_Window * window) );
NV_SDL_FUN( int , SDL_UpdateWindowSurfaceRects, (SDL_Window * window,const SDL_Rect * rects,int numrects) );
NV_SDL_FUN( void , SDL_SetWindowGrab, (SDL_Window * window,SDL_bool grabbed) );
NV_SDL_FUN( SDL_bool , SDL_GetWindowGrab, (SDL_Window * window) );
NV_SDL_FUN( int , SDL_SetWindowBrightness, (SDL_Window * window, float brightness) );
NV_SDL_FUN( float , SDL_GetWindowBrightness, (SDL_Window * window) );
NV_SDL_FUN( int , SDL_SetWindowGammaRamp, (SDL_Window * window,const Uint16 * red,const Uint16 * green,const Uint16 * blue) );
NV_SDL_FUN( int , SDL_GetWindowGammaRamp, (SDL_Window * window,Uint16 * red,Uint16 * green,Uint16 * blue) );
NV_SDL_FUN( void , SDL_DestroyWindow, (SDL_Window * window) );
NV_SDL_FUN( SDL_bool , SDL_IsScreenSaverEnabled, (void) );
NV_SDL_FUN( void , SDL_EnableScreenSaver, (void) );
NV_SDL_FUN( void , SDL_DisableScreenSaver, (void) );
NV_SDL_FUN( void , SDL_GL_UnloadLibrary, (void) );
NV_SDL_FUN( SDL_bool , SDL_GL_ExtensionSupported, (const char*extension) );
NV_SDL_FUN( SDL_GLContext , SDL_GL_CreateContext, (SDL_Window *window) );
NV_SDL_FUN( int , SDL_GL_MakeCurrent, (SDL_Window * window,SDL_GLContext context) );
NV_SDL_FUN( SDL_Window* , SDL_GL_GetCurrentWindow, (void) );
NV_SDL_FUN( SDL_GLContext , SDL_GL_GetCurrentContext, (void) );
NV_SDL_FUN( int , SDL_GL_SetSwapInterval, (int interval) );
NV_SDL_FUN( int , SDL_GL_GetSwapInterval, (void) );
NV_SDL_FUN( void , SDL_GL_SwapWindow, (SDL_Window * window) );
NV_SDL_FUN( void , SDL_GL_DeleteContext, (SDL_GLContext context) );

/* SDL_audio.h functions */
NV_SDL_FUN( int , SDL_GetNumAudioDrivers, (void) );
NV_SDL_FUN( const char *, SDL_GetAudioDriver, (int index) );
NV_SDL_FUN( const char *, SDL_GetCurrentAudioDriver, (void) );
NV_SDL_FUN( int , SDL_GetNumAudioDevices, (int iscapture) );
NV_SDL_FUN( const char *, SDL_GetAudioDeviceName, (int index, int iscapture) );
NV_SDL_FUN( SDL_AudioDeviceID , SDL_OpenAudioDevice, (const char *device, int iscapture, const SDL_AudioSpec * desired, SDL_AudioSpec * obtained, int allowed_changes) );
NV_SDL_FUN( SDL_AudioStatus , SDL_GetAudioDeviceStatus, (SDL_AudioDeviceID dev) );
NV_SDL_FUN( void , SDL_PauseAudioDevice, (SDL_AudioDeviceID dev, int pause_on) );
NV_SDL_FUN( void , SDL_MixAudioFormat, (Uint8 * dst, const Uint8 * src, SDL_AudioFormat format, Uint32 len, int volume) );
NV_SDL_FUN( void , SDL_LockAudioDevice, (SDL_AudioDeviceID dev) );
NV_SDL_FUN( void , SDL_UnlockAudioDevice, (SDL_AudioDeviceID dev) );
NV_SDL_FUN( void , SDL_CloseAudioDevice, (SDL_AudioDeviceID dev) );
// NV_SDL_FUN( int , SDL_AudioDeviceConnected, (SDL_AudioDeviceID dev) );

/* SDL_cpuinfo.h functions */
NV_SDL_FUN( int , SDL_GetCPUCount, (void) );
NV_SDL_FUN( int , SDL_GetCPUCacheLineSize, (void) );
NV_SDL_FUN( SDL_bool, SDL_HasSSE3, (void) );
NV_SDL_FUN( SDL_bool, SDL_HasSSE41, (void) );
NV_SDL_FUN( SDL_bool, SDL_HasSSE42, (void) );

/* SDL_error.h functions */
NV_SDL_FUN( int, SDL_SetError, (const char *fmt, ...) );
NV_SDL_FUN( int, SDL_Error, (SDL_errorcode code) );

/* SDL_keyboard.h functions */
NV_SDL_FUN( SDL_Window * , SDL_GetKeyboardFocus, (void) );
NV_SDL_FUN( const Uint8 *, SDL_GetKeyboardState, (int *numkeys) );
NV_SDL_FUN( SDL_Keymod , SDL_GetModState, (void) );
NV_SDL_FUN( void , SDL_SetModState, (SDL_Keymod modstate) );
NV_SDL_FUN( SDL_Keycode , SDL_GetKeyFromScancode, (SDL_Scancode scancode) );
NV_SDL_FUN( SDL_Scancode , SDL_GetScancodeFromKey, (SDL_Keycode key) );
NV_SDL_FUN( const char *, SDL_GetScancodeName, (SDL_Scancode scancode) );
NV_SDL_FUN( SDL_Scancode , SDL_GetScancodeFromName, (const char *name) );
NV_SDL_FUN( const char *, SDL_GetKeyName, (SDL_Keycode key) );
NV_SDL_FUN( SDL_Keycode , SDL_GetKeyFromName, (const char *name) );
NV_SDL_FUN( void , SDL_StartTextInput, (void) );
NV_SDL_FUN( SDL_bool , SDL_IsTextInputActive, (void) );
NV_SDL_FUN( void , SDL_StopTextInput, (void) );
NV_SDL_FUN( void , SDL_SetTextInputRect, (SDL_Rect *rect) );
NV_SDL_FUN( SDL_bool , SDL_HasScreenKeyboardSupport, (void) );
NV_SDL_FUN( SDL_bool , SDL_IsScreenKeyboardShown, (SDL_Window *window) ); 

/* SDL_mouse.h functions */
NV_SDL_FUN( SDL_Window * , SDL_GetMouseFocus, (void) );
NV_SDL_FUN( Uint32 , SDL_GetMouseState, (int *x, int *y) );
NV_SDL_FUN( Uint32 , SDL_GetRelativeMouseState, (int *x, int *y) );
NV_SDL_FUN( void , SDL_WarpMouseInWindow, (SDL_Window * window,int x, int y) );
NV_SDL_FUN( int , SDL_SetRelativeMouseMode, (SDL_bool enabled) );
NV_SDL_FUN( SDL_bool , SDL_GetRelativeMouseMode, (void) );
NV_SDL_FUN( SDL_Cursor *, SDL_CreateCursor, (const Uint8 * data,const Uint8 * mask,int w, int h, int hot_x,int hot_y) );
NV_SDL_FUN( SDL_Cursor *, SDL_CreateColorCursor, (SDL_Surface *surface,int hot_x,int hot_y) );
NV_SDL_FUN( SDL_Cursor *, SDL_CreateSystemCursor, (SDL_SystemCursor id) );
NV_SDL_FUN( SDL_Cursor *, SDL_GetDefaultCursor, (void) );

NV_SDL_FUN( const char *, SDL_JoystickName, (SDL_Joystick * joystick) );
NV_SDL_FUN( const char *, SDL_JoystickNameForIndex, (int device_index) );
NV_SDL_FUN( SDL_JoystickGUID , SDL_JoystickGetDeviceGUID, (int device_index) );
NV_SDL_FUN( SDL_JoystickGUID , SDL_JoystickGetGUID, (SDL_Joystick * joystick) );
NV_SDL_FUN( void, SDL_JoystickGetGUIDString, (SDL_JoystickGUID guid, char *pszGUID, int cbGUID) );
NV_SDL_FUN( SDL_JoystickGUID , SDL_JoystickGetGUIDFromString, (const char *pchGUID) );
NV_SDL_FUN( SDL_bool , SDL_JoystickGetAttached, (SDL_Joystick * joystick) );
NV_SDL_FUN( SDL_JoystickID , SDL_JoystickInstanceID, (SDL_Joystick * joystick) );

NV_SDL_FUN( Uint64 , SDL_GetPerformanceCounter, (void) ); 
NV_SDL_FUN( Uint64 , SDL_GetPerformanceFrequency, (void) );

/* SDL_version.h functions */
NV_SDL_FUN( void , SDL_GetVersion, (SDL_version * ver) );
NV_SDL_FUN( const char *, SDL_GetRevision, (void) );
NV_SDL_FUN( int , SDL_GetRevisionNumber, (void) );

/* SDL_event.h functions */
NV_SDL_FUN( int , SDL_PeepEvents, (SDL_Event * events, int numevents,SDL_eventaction action,Uint32 minType, Uint32 maxType) );
NV_SDL_FUN( SDL_bool , SDL_HasEvent, (Uint32 type) );
NV_SDL_FUN( SDL_bool , SDL_HasEvents, (Uint32 minType, Uint32 maxType) );
NV_SDL_FUN( void , SDL_FlushEvent, (Uint32 type) );
NV_SDL_FUN( void , SDL_FlushEvents, (Uint32 minType, Uint32 maxType) );
NV_SDL_FUN( int , SDL_WaitEventTimeout, (SDL_Event * event,int timeout) );
NV_SDL_FUN( void , SDL_SetEventFilter, (SDL_EventFilter filter,void *userdata) );
NV_SDL_FUN( SDL_bool , SDL_GetEventFilter, (SDL_EventFilter * filter,void **userdata) );
NV_SDL_FUN( void , SDL_AddEventWatch, (SDL_EventFilter filter,void *userdata) );
NV_SDL_FUN( void , SDL_DelEventWatch, (SDL_EventFilter filter,void *userdata) );
NV_SDL_FUN( void , SDL_FilterEvents, (SDL_EventFilter filter,void *userdata) );
NV_SDL_FUN( Uint8 , SDL_EventState, (Uint32 type, int state) );
NV_SDL_FUN( Uint32 , SDL_RegisterEvents, (int numevents) ); 

/* SDL_clipboard.h functions (2.0 only) */
NV_SDL_FUN( int, SDL_SetClipboardText, (const char *text) );
NV_SDL_FUN( char *, SDL_GetClipboardText, (void) );
NV_SDL_FUN( SDL_bool, SDL_HasClipboardText, (void) );

/* SDL_gamecontroller.h functions (2.0 only) */
NV_SDL_FUN( int , SDL_GameControllerAddMapping, ( const char* mappingString ) );
NV_SDL_FUN( char * , SDL_GameControllerMappingForGUID, ( SDL_JoystickGUID guid ) );
NV_SDL_FUN( char * , SDL_GameControllerMapping, ( SDL_GameController * gamecontroller ) );
NV_SDL_FUN( SDL_bool , SDL_IsGameController, (int joystick_index) );
NV_SDL_FUN( const char *, SDL_GameControllerNameForIndex, (int joystick_index) );
NV_SDL_FUN( SDL_GameController *, SDL_GameControllerOpen, (int joystick_index) );
NV_SDL_FUN( const char *, SDL_GameControllerName, (SDL_GameController *gamecontroller) );
NV_SDL_FUN( SDL_bool , SDL_GameControllerGetAttached, (SDL_GameController *gamecontroller) );
NV_SDL_FUN( SDL_Joystick *, SDL_GameControllerGetJoystick, (SDL_GameController *gamecontroller) );
NV_SDL_FUN( int , SDL_GameControllerEventState, (int state) );
NV_SDL_FUN( void , SDL_GameControllerUpdate, (void) );
NV_SDL_FUN( SDL_GameControllerAxis , SDL_GameControllerGetAxisFromString, (const char *pchString) );
NV_SDL_FUN( const char* , SDL_GameControllerGetStringForAxis, (SDL_GameControllerAxis axis) );
NV_SDL_FUN( SDL_GameControllerButtonBind , SDL_GameControllerGetBindForAxis, (SDL_GameController *gamecontroller,SDL_GameControllerAxis axis) );
NV_SDL_FUN( Sint16 , SDL_GameControllerGetAxis, (SDL_GameController *gamecontroller,SDL_GameControllerAxis axis) );
NV_SDL_FUN( SDL_GameControllerButton , SDL_GameControllerGetButtonFromString, (const char *pchString) );
NV_SDL_FUN( const char* , SDL_GameControllerGetStringForButton, (SDL_GameControllerButton button) );
NV_SDL_FUN( SDL_GameControllerButtonBind , SDL_GameControllerGetBindForButton, (SDL_GameController *gamecontroller,SDL_GameControllerButton button) );
NV_SDL_FUN( Uint8 , SDL_GameControllerGetButton, (SDL_GameController *gamecontroller,SDL_GameControllerButton button) );
NV_SDL_FUN( void , SDL_GameControllerClose, (SDL_GameController *gamecontroller) );

/* SDL_hints.h functions (2.0 only) */
NV_SDL_FUN( SDL_bool , SDL_SetHintWithPriority, (const char *name,const char *value,SDL_HintPriority priority) );
NV_SDL_FUN( SDL_bool , SDL_SetHint, (const char *name,const char *value) );
NV_SDL_FUN( const char * , SDL_GetHint, (const char *name) );
NV_SDL_FUN( void , SDL_ClearHints, (void) ); 

/* SDL_main.h functions (2.0 only) */
NV_SDL_FUN( void , SDL_SetMainReady, (void) );
// NV_SDL_FUN( int , SDL_RegisterApp, (char *name, Uint32 style,void *hInst) );
// NV_SDL_FUN( void , SDL_UnregisterApp, (void) ); 

/* SDL_messagebox.h functions (2.0 only) */
NV_SDL_FUN( int , SDL_ShowMessageBox, (const SDL_MessageBoxData *messageboxdata, int *buttonid) );
NV_SDL_FUN( int , SDL_ShowSimpleMessageBox, (Uint32 flags, const char *title, const char *message, SDL_Window *window) ); 

/* SDL_pixels.h functions (2.0 only) */
NV_SDL_FUN( const char* , SDL_GetPixelFormatName, (Uint32 format) );
NV_SDL_FUN( SDL_bool , SDL_PixelFormatEnumToMasks, (Uint32 format,int *bpp,Uint32 * Rmask,Uint32 * Gmask,Uint32 * Bmask,Uint32 * Amask) );
NV_SDL_FUN( Uint32 , SDL_MasksToPixelFormatEnum, (int bpp,Uint32 Rmask,Uint32 Gmask,Uint32 Bmask,Uint32 Amask) );
NV_SDL_FUN( SDL_PixelFormat * , SDL_AllocFormat, (Uint32 pixel_format) );
NV_SDL_FUN( void , SDL_FreeFormat, (SDL_PixelFormat *format) );
NV_SDL_FUN( SDL_Palette *, SDL_AllocPalette, (int ncolors) );
NV_SDL_FUN( int , SDL_SetPixelFormatPalette, (SDL_PixelFormat * format,SDL_Palette *palette) );
NV_SDL_FUN( int , SDL_SetPaletteColors, (SDL_Palette * palette,const SDL_Color * colors,int firstcolor, int ncolors) );
NV_SDL_FUN( void , SDL_FreePalette, (SDL_Palette * palette) );
NV_SDL_FUN( Uint32 , SDL_MapRGB, (const SDL_PixelFormat * format,Uint8 r, Uint8 g, Uint8 b) );
NV_SDL_FUN( Uint32 , SDL_MapRGBA, (const SDL_PixelFormat * format,Uint8 r, Uint8 g, Uint8 b,Uint8 a) );
NV_SDL_FUN( void , SDL_GetRGB, (Uint32 pixel,const SDL_PixelFormat * format,Uint8 * r, Uint8 * g, Uint8 * b) );
NV_SDL_FUN( void , SDL_GetRGBA, (Uint32 pixel,const SDL_PixelFormat * format,Uint8 * r, Uint8 * g, Uint8 * b,Uint8 * a) );
NV_SDL_FUN( void , SDL_CalculateGammaRamp, (float gamma, Uint16 * ramp) );  

/* SDL_platform.h functions (2.0 only) */
NV_SDL_FUN( const char * , SDL_GetPlatform , (void) );

/* SDL_power.h functions (2.0 only) */
NV_SDL_FUN( SDL_PowerState , SDL_GetPowerInfo, (int *secs, int *pct) ); 

/* SDL_renderer.h functions (2.0 only) */
NV_SDL_FUN( int , SDL_GetNumRenderDrivers, (void) );
NV_SDL_FUN( int , SDL_GetRenderDriverInfo, (int index,SDL_RendererInfo * info) );
NV_SDL_FUN( int , SDL_CreateWindowAndRenderer, (int width, int height, Uint32 window_flags,SDL_Window **window, SDL_Renderer **renderer) );
NV_SDL_FUN( SDL_Renderer * , SDL_CreateRenderer, (SDL_Window * window,int index, Uint32 flags) );
NV_SDL_FUN( SDL_Renderer * , SDL_CreateSoftwareRenderer, (SDL_Surface * surface) );
NV_SDL_FUN( SDL_Renderer * , SDL_GetRenderer, (SDL_Window * window) );
NV_SDL_FUN( int , SDL_GetRendererInfo, (SDL_Renderer * renderer,SDL_RendererInfo * info) );
NV_SDL_FUN( int , SDL_GetRendererOutputSize, (SDL_Renderer * renderer,int *w, int *h) );
NV_SDL_FUN( SDL_Texture * , SDL_CreateTexture, (SDL_Renderer * renderer,Uint32 format,int access, int w,int h) );
NV_SDL_FUN( SDL_Texture * , SDL_CreateTextureFromSurface, (SDL_Renderer * renderer, SDL_Surface * surface) );
NV_SDL_FUN( int , SDL_QueryTexture, (SDL_Texture * texture,Uint32 * format, int *access,int *w, int *h) );
NV_SDL_FUN( int , SDL_SetTextureColorMod, (SDL_Texture * texture,Uint8 r, Uint8 g, Uint8 b) );
NV_SDL_FUN( int , SDL_GetTextureColorMod, (SDL_Texture * texture,Uint8 * r, Uint8 * g,Uint8 * b) );
NV_SDL_FUN( int , SDL_SetTextureAlphaMod, (SDL_Texture * texture,Uint8 alpha) );
NV_SDL_FUN( int , SDL_GetTextureAlphaMod, (SDL_Texture * texture,Uint8 * alpha) );
NV_SDL_FUN( int , SDL_SetTextureBlendMode, (SDL_Texture * texture,SDL_BlendMode blendMode) );
NV_SDL_FUN( int , SDL_GetTextureBlendMode, (SDL_Texture * texture,SDL_BlendMode *blendMode) );
NV_SDL_FUN( int , SDL_UpdateTexture, (SDL_Texture * texture,const SDL_Rect * rect,const void *pixels, int pitch) );
NV_SDL_FUN( int , SDL_LockTexture, (SDL_Texture * texture,const SDL_Rect * rect,void **pixels, int *pitch) );
NV_SDL_FUN( void , SDL_UnlockTexture, (SDL_Texture * texture) );
NV_SDL_FUN( SDL_bool , SDL_RenderTargetSupported, (SDL_Renderer *renderer) );
NV_SDL_FUN( int , SDL_SetRenderTarget, (SDL_Renderer *renderer,SDL_Texture *texture) );
NV_SDL_FUN( SDL_Texture * , SDL_GetRenderTarget, (SDL_Renderer *renderer) );
NV_SDL_FUN( int , SDL_RenderSetLogicalSize, (SDL_Renderer * renderer, int w, int h) );
NV_SDL_FUN( void , SDL_RenderGetLogicalSize, (SDL_Renderer * renderer, int *w, int *h) );
NV_SDL_FUN( int , SDL_RenderSetViewport, (SDL_Renderer * renderer,const SDL_Rect * rect) );
NV_SDL_FUN( void , SDL_RenderGetViewport, (SDL_Renderer * renderer,SDL_Rect * rect) );
NV_SDL_FUN( int , SDL_RenderSetClipRect, (SDL_Renderer * renderer,const SDL_Rect * rect) );
NV_SDL_FUN( void , SDL_RenderGetClipRect, (SDL_Renderer * renderer,SDL_Rect * rect) );
NV_SDL_FUN( int , SDL_RenderSetScale, (SDL_Renderer * renderer,float scaleX, float scaleY) );
NV_SDL_FUN( void , SDL_RenderGetScale, (SDL_Renderer * renderer,float *scaleX, float *scaleY) );
NV_SDL_FUN( int , SDL_SetRenderDrawColor, (SDL_Renderer * renderer,Uint8 r, Uint8 g, Uint8 b,Uint8 a) );
NV_SDL_FUN( int , SDL_GetRenderDrawColor, (SDL_Renderer * renderer,Uint8 * r, Uint8 * g, Uint8 * b,Uint8 * a) );
NV_SDL_FUN( int , SDL_SetRenderDrawBlendMode, (SDL_Renderer * renderer,SDL_BlendMode blendMode) );
NV_SDL_FUN( int , SDL_GetRenderDrawBlendMode, (SDL_Renderer * renderer,SDL_BlendMode *blendMode) );
NV_SDL_FUN( int , SDL_RenderClear, (SDL_Renderer * renderer) );
NV_SDL_FUN( int , SDL_RenderDrawPoint, (SDL_Renderer * renderer,int x, int y) );
NV_SDL_FUN( int , SDL_RenderDrawPoints, (SDL_Renderer * renderer,const SDL_Point * points,int count) );
NV_SDL_FUN( int , SDL_RenderDrawLine, (SDL_Renderer * renderer,int x1, int y1, int x2, int y2) );
NV_SDL_FUN( int , SDL_RenderDrawLines, (SDL_Renderer * renderer,const SDL_Point * points,int count) );
NV_SDL_FUN( int , SDL_RenderDrawRect, (SDL_Renderer * renderer,const SDL_Rect * rect) );
NV_SDL_FUN( int , SDL_RenderDrawRects, (SDL_Renderer * renderer,const SDL_Rect * rects,int count) );
NV_SDL_FUN( int , SDL_RenderFillRect, (SDL_Renderer * renderer,const SDL_Rect * rect) );
NV_SDL_FUN( int , SDL_RenderFillRects, (SDL_Renderer * renderer,const SDL_Rect * rects,int count) );
NV_SDL_FUN( int , SDL_RenderCopy, (SDL_Renderer * renderer,SDL_Texture * texture,const SDL_Rect * srcrect,const SDL_Rect * dstrect) );
NV_SDL_FUN( int , SDL_RenderCopyEx, (SDL_Renderer * renderer,SDL_Texture * texture,const SDL_Rect * srcrect,const SDL_Rect * dstrect,const double angle,const SDL_Point *center,const SDL_RendererFlip flip) );
NV_SDL_FUN( int , SDL_RenderReadPixels, (SDL_Renderer * renderer,const SDL_Rect * rect,Uint32 format,void *pixels, int pitch) );
NV_SDL_FUN( void , SDL_RenderPresent, (SDL_Renderer * renderer) );
NV_SDL_FUN( void , SDL_DestroyTexture, (SDL_Texture * texture) );
NV_SDL_FUN( void , SDL_DestroyRenderer, (SDL_Renderer * renderer) );
NV_SDL_FUN( int , SDL_GL_BindTexture, (SDL_Texture *texture, float *texw, float *texh) );
NV_SDL_FUN( int , SDL_GL_UnbindTexture, (SDL_Texture *texture) );

/* SDL_shape.h functions (2.0 only) */
NV_SDL_FUN( int , SDL_SetWindowShape, (SDL_Window *window,SDL_Surface *shape,SDL_WindowShapeMode *shape_mode) );
NV_SDL_FUN( int , SDL_GetShapedWindowMode, (SDL_Window *window,SDL_WindowShapeMode *shape_mode) ); 

/* SDL_surface.h functions (2.0 only) */
NV_SDL_FUN( int , SDL_SetSurfacePalette, (SDL_Surface * surface,SDL_Palette * palette) );
NV_SDL_FUN( int , SDL_SetSurfaceRLE, (SDL_Surface * surface,int flag) );
NV_SDL_FUN( int , SDL_SetColorKey, (SDL_Surface * surface,int flag, Uint32 key) );
NV_SDL_FUN( int , SDL_GetColorKey, (SDL_Surface * surface,Uint32 * key) );
NV_SDL_FUN( int , SDL_SetSurfaceColorMod, (SDL_Surface * surface,Uint8 r, Uint8 g, Uint8 b) );
NV_SDL_FUN( int , SDL_GetSurfaceColorMod, (SDL_Surface * surface,Uint8 * r, Uint8 * g,Uint8 * b) );
NV_SDL_FUN( int , SDL_SetSurfaceAlphaMod, (SDL_Surface * surface,Uint8 alpha) );
NV_SDL_FUN( int , SDL_GetSurfaceAlphaMod, (SDL_Surface * surface,Uint8 * alpha) );
NV_SDL_FUN( int , SDL_SetSurfaceBlendMode, (SDL_Surface * surface,SDL_BlendMode blendMode) );
NV_SDL_FUN( int , SDL_GetSurfaceBlendMode, (SDL_Surface * surface,SDL_BlendMode *blendMode) );

NV_SDL_FUN( SDL_Surface *, SDL_ConvertSurfaceFormat, (SDL_Surface * src, Uint32 pixel_format, Uint32 flags) );
NV_SDL_FUN( int , SDL_ConvertPixels, (int width, int height,Uint32 src_format,const void * src, int src_pitch,Uint32 dst_format,void * dst, int dst_pitch) );
NV_SDL_FUN( int , SDL_FillRect, (SDL_Surface * dst, const SDL_Rect * rect, Uint32 color) );
NV_SDL_FUN( int , SDL_FillRects, (SDL_Surface * dst, const SDL_Rect * rects, int count, Uint32 color) );
NV_SDL_FUN( int , SDL_UpperBlit, (SDL_Surface * src, const SDL_Rect * srcrect,SDL_Surface * dst, SDL_Rect * dstrect) );
NV_SDL_FUN( int , SDL_LowerBlit, (SDL_Surface * src, SDL_Rect * srcrect,SDL_Surface * dst, SDL_Rect * dstrect) );
NV_SDL_FUN( int , SDL_SoftStretch, (SDL_Surface * src,const SDL_Rect * srcrect,SDL_Surface * dst,const SDL_Rect * dstrect) );
NV_SDL_FUN( int , SDL_UpperBlitScaled, (SDL_Surface * src, const SDL_Rect * srcrect,SDL_Surface * dst, SDL_Rect * dstrect) );
NV_SDL_FUN( int , SDL_LowerBlitScaled, (SDL_Surface * src, SDL_Rect * srcrect,SDL_Surface * dst, SDL_Rect * dstrect) );
NV_SDL_FUN( int , SDL_GetNumTouchDevices, (void) );
NV_SDL_FUN( SDL_TouchID , SDL_GetTouchDevice, (int index) );
NV_SDL_FUN( int , SDL_GetNumTouchFingers, (SDL_TouchID touchID) );
NV_SDL_FUN( SDL_Finger * , SDL_GetTouchFinger, (SDL_TouchID touchID, int index) ); 

NV_SDL_FUN( char *, SDL_getenv, (const char *name) );
NV_SDL_FUN( int , SDL_setenv, (const char *name, const char *value, int overwrite) );
NV_SDL_FUN( int , SDL_isdigit, (int x) );
NV_SDL_FUN( int , SDL_isspace, (int x) );
NV_SDL_FUN( int , SDL_toupper, (int x) );
NV_SDL_FUN( int , SDL_tolower, (int x) ); 