// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file gl_texture2d.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Texture2D class
 */

#ifndef NV_GL_TEXTURE2D_HH
#define NV_GL_TEXTURE2D_HH

#include <nv/interface/texture2d.hh>
#include <nv/gl/gl_names.hh>

namespace nv
{

	class gl_texture2d : public texture2d
	{
	public:
		gl_texture2d( ivec2 size, pixel_format aformat, datatype adatatype, sampler asampler, void* data = nullptr );
		virtual void assign( void* data );
		virtual void bind( size_t slot = 0 );
		virtual void unbind();
		virtual bool is_valid() const;
	protected:
		gl_texture_name m_name;
	};
	
} // namespace nv

#endif // NV_GL_TEXTURE2D_HH
