// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_KEYFRAMED_MESH_HH
#define NV_KEYFRAMED_MESH_HH

#include <nv/common.hh>
#include <nv/interface/context.hh>
#include <nv/interface/animated_mesh.hh>
#include <nv/formats/md3_loader.hh>

namespace nv
{

	class keyframed_mesh : public animated_mesh
	{
	public:
		keyframed_mesh( device* a_device, const mesh_data* a_data, const mesh_nodes_data* a_tag_map );
		virtual size_t get_index_count() const { return m_index_count; }
		virtual void run_animation( animation_entry* a_anim );
		size_t get_max_frames() const;
		virtual transform get_node_transform( uint32 node_id ) const;
		virtual mat4 get_node_matrix( uint32 node_id ) const;
		virtual void update_animation( animation_entry*, uint32 a_anim_time );
		virtual void update( program* a_program ) const;
		virtual ~keyframed_mesh();
	protected:
		virtual void set_frame( uint32 frame );

		struct vertex_pn
		{
			vec3 position;
			vec3 normal;
		};
		struct vertex_pnt
		{
			vec3 position;
			vec3 normal;
			vec4 tangent;
		};
		struct vertex_t
		{
			vec2 texcoord;
		};

		const mesh_data*        m_mesh_data;
		const mesh_nodes_data*  m_tag_map;
		const mesh_raw_channel* m_vchannel;

		uint32 m_last_frame;
		uint32 m_next_frame;
		uint32 m_vsize;
		f32    m_interpolation;
		bool   m_has_tangent;
		bool   m_active;

		uint32 m_index_count;
		uint32 m_frame_count;
		uint32 m_vertex_count;
	};


	class keyframed_mesh_gpu : public keyframed_mesh
	{
	public:
		keyframed_mesh_gpu( device* a_device, const mesh_data* a_data, const mesh_nodes_data* a_tag_map, program* a_program );
		void update( uint32 ms );
	private:
		int m_loc_next_position;
		int m_loc_next_normal;
		int m_loc_next_tangent;

		uint32 m_gpu_last_frame;
		uint32 m_gpu_next_frame;
	};

	class keyframed_mesh_cpu : public keyframed_mesh
	{
	public:
		keyframed_mesh_cpu( device* a_device, const mesh_data* a_data, const mesh_nodes_data* a_tag_map );
		void update( uint32 ms );
		~keyframed_mesh_cpu();
	private:
		uint8*         m_data;
		vertex_buffer* m_vb;
	};

} // namespace nv

#endif // NV_KEYFRAMED_MESH_HH
