// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file md2_loader.hh
 * @author Kornel Kisielewicz
 * @brief md2 loader
 */

#ifndef NV_MD2_LOADER_HH
#define NV_MD2_LOADER_HH

#include <nv/common.hh>
#include <unordered_map>
#include <vector>
#include <nv/interface/mesh_loader.hh>

namespace nv 
{

	class md2_loader : public mesh_loader
	{
	public:
		md2_loader();
		virtual ~md2_loader();
		virtual bool load( stream& source );
		virtual mesh_data* release_mesh_data( size_t index = 0 );
		virtual mesh_data_pack* release_mesh_data_pack();
		virtual size_t get_mesh_count() const { return 1; }
	private:
		void release_mesh_frame( mesh_data* data, sint32 frame );
		size_t get_max_frames() const;
		void reindex();
	private:
		void* m_md2;
		std::vector< uint16 > m_new_indexes;
		std::vector< uint16 > m_new_vindexes;
		std::vector< uint16 > m_new_tindexes;
	};

}

#endif // NV_MD2_LOADER_HH
