// Copyright (C) 2014 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file animated_mesh.hh
 * @author Kornel Kisielewicz
 * @brief animated_mesh
 */

#ifndef NV_ANIMATED_MESH_HH
#define NV_ANIMATED_MESH_HH

#include <nv/common.hh>
#include <nv/math.hh>
#include <nv/transform.hh>
#include <nv/interface/context.hh>

namespace nv
{

	class animation_entry
	{
	public:
		animation_entry( const std::string& name, bool looping, uint32 frame_rate, float a_start, float a_end ) : m_name( name ), m_looping( looping ), m_frame_rate( frame_rate ),
		m_start( a_start ), m_end( a_end ), m_duration( m_end - m_start ) {}
		const std::string& get_name() const { return m_name; }
		uint32 get_frame_rate() const { return m_frame_rate; }
		float get_duration() const { return m_duration; }
		float get_start() const { return m_start; }
		float get_end() const  { return m_end; }
		bool is_looping() const { return m_looping; }
		virtual ~animation_entry() {}
	protected:
		std::string m_name;
		bool   m_looping;
		uint32 m_frame_rate;
		float  m_start;
		float  m_end;
		float  m_duration;
	};

	class animated_mesh : public mesh_interface
	{
	public:
		animated_mesh() {}
		virtual void update_animation( animation_entry*, uint32 ) {}
		virtual void run_animation( animation_entry* ) {}
		virtual transform get_node_transform( uint32 ) const { return transform(); }
		virtual mat4 get_node_matrix( uint32 ) const { return mat4(); }
	};


}

#endif // NV_ANIMATED_MESH_HH
