project "nv"
	location (_ACTION)
	language "C++"
	kind "StaticLib"
	includedirs { "." }
	files { "nv/**.hh", "nv/**.inl", "nv/**.inc", "src/**.cc" }
	targetname "nv"

-- injection!
solution( solution().name )
	configuration "*"
		includedirs { os.getenv("GLM_PATH") }
	configuration "gmake"
		if _ACTION == "gmake-clang" then
			buildoptions { 
				"-std=c++11",
--                                -- on Mac OS X don't try to use old stdc++
--                                "-stdlib=libc++",
				"-Weverything",
				-- obviously we don't care about C++98 compatibility
				"-Wno-c++98-compat", 
				-- obviously we don't care about C++98 compatibility
				"-Wno-c++98-compat-pedantic",
				-- an evil one has to embrace
				"-Wno-float-equal",
				-- padding is a non-issue at the moment
				"-Wno-padded",
				-- we don't want to list all 128 keys of the key
				-- enum each time, right?
				"-Wno-switch-enum",
				-- yes, we need exit time destructors for libraries
				"-Wno-exit-time-destructors",
				-- same here
				"-Wno-global-constructors",
				-- no reasonable way to fix this with abstract 
				-- interfaces.
				"-Wno-weak-vtables"
			}
			--buildoptions { 
            --                    "-stdlib=libc++"
			--}
		else
			buildoptions { "-std=c++0x" }
		end

	configuration "linux"
		linkoptions { "-ldl" }

	configuration "vs*"
		defines { "_SECURE_SCL=0", "_CRT_SECURE_NO_WARNINGS=1" }

if _ACTION == "gmake-clang" then
	premake.gcc.cc  = "clang"
	premake.gcc.cxx = "clang++"
	_ACTION = "gmake"
end

premake.action.add { 
	trigger = "gmake-clang", 
	description = "gmake file with clang overrides, needs 'make -R' to work",
}

if _ACTION == "clean" then
	for action in premake.action.each() do
		os.rmdir(action.trigger)
	end
end
