// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_LIB_SDL_IMAGE_HH
#define NV_LIB_SDL_IMAGE_HH

#include <nv/common.hh>
#include <nv/lib/sdl12.hh>

#if NV_PLATFORM == NV_WINDOWS
#	define NV_SDL_IMAGE_PATH "SDL_image.dll"
#elif NV_PLATFORM == NV_APPLE
#	define NV_SDL_IMAGE_PATH "SDL_image.framework/SDL_image"
#else
#	define NV_SDL_IMAGE_PATH "libSDL_image-1.2.so.0"
#endif

extern "C" {

/** SDL_image defines */
#define SDL_IMAGE_MAJOR_VERSION	1
#define SDL_IMAGE_MINOR_VERSION	2
#define SDL_IMAGE_PATCHLEVEL	11
#define SDL_IMAGE_VERSION(X)						\
{									\
	(X)->major = SDL_IMAGE_MAJOR_VERSION;				\
	(X)->minor = SDL_IMAGE_MINOR_VERSION;				\
	(X)->patch = SDL_IMAGE_PATCHLEVEL;				\
}
typedef enum
{
    IMG_INIT_JPG = 0x00000001,
    IMG_INIT_PNG = 0x00000002,
    IMG_INIT_TIF = 0x00000004,
} IMG_InitFlags;

NV_SDL_FUN( const SDL_version *, IMG_Linked_Version, (void) );
NV_SDL_FUN( int, IMG_Init, (int flags) );
NV_SDL_FUN( void, IMG_Quit, (void) );
NV_SDL_FUN( SDL_Surface *, IMG_LoadTyped_RW, (SDL_RWops *src, int freesrc, char *type) );
NV_SDL_FUN( SDL_Surface *, IMG_Load, (const char *file) );
NV_SDL_FUN( SDL_Surface *, IMG_Load_RW, (SDL_RWops *src, int freesrc) );
NV_SDL_FUN( int, IMG_isICO, (SDL_RWops *src) );
NV_SDL_FUN( int, IMG_isCUR, (SDL_RWops *src) );
NV_SDL_FUN( int, IMG_isBMP, (SDL_RWops *src) );
NV_SDL_FUN( int, IMG_isGIF, (SDL_RWops *src) );
NV_SDL_FUN( int, IMG_isJPG, (SDL_RWops *src) );
NV_SDL_FUN( int, IMG_isPNG, (SDL_RWops *src) );
NV_SDL_FUN( int, IMG_isTIF, (SDL_RWops *src) );
NV_SDL_FUN( SDL_Surface *, IMG_LoadICO_RW, (SDL_RWops *src) );
NV_SDL_FUN( SDL_Surface *, IMG_LoadCUR_RW, (SDL_RWops *src) );
NV_SDL_FUN( SDL_Surface *, IMG_LoadBMP_RW, (SDL_RWops *src) );
NV_SDL_FUN( SDL_Surface *, IMG_LoadGIF_RW, (SDL_RWops *src) );
NV_SDL_FUN( SDL_Surface *, IMG_LoadJPG_RW, (SDL_RWops *src) );
NV_SDL_FUN( SDL_Surface *, IMG_LoadPNG_RW, (SDL_RWops *src) );
NV_SDL_FUN( SDL_Surface *, IMG_LoadTGA_RW, (SDL_RWops *src) );
NV_SDL_FUN( SDL_Surface *, IMG_LoadTIF_RW, (SDL_RWops *src) );
}

namespace nv {
/* Dynamic load support */
#	if defined( NV_SDL_DYNAMIC )
		bool load_sdl_image_library( const char* path = NV_SDL_IMAGE_PATH );
#	else
		inline bool load_sdl_image_library( const char* path = "" ) { return true; }
#	endif
}

#endif // NV_LIB_SDL_IMAGE_HH
