// Copyright (C) 2014 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_NMD_LOADER_HH
#define NV_NMD_LOADER_HH

#include <nv/common.hh>
#include <nv/interface/mesh_loader.hh>
#include <nv/interface/mesh_data.hh>
#include <nv/io/string_table.hh>

namespace nv 
{

	enum class nmd_type : uint16
	{
		MESH,
		STREAM,
		NODE,
		STRING_TABLE,
		ANIMATION,
		KEY_CHANNEL,
	};

	struct nmd_header
	{
		uint32 id;
		uint32 version;
		uint32 elements;
	};

	struct nmd_element_header
	{
		nmd_type type;
		uint16   name;
		uint16   children;
		uint32   size;
	};

	struct nmd_animation_header
	{
		uint16 frame_rate;
		float  duration;
		bool   flat;
	};

	struct nmd_node_header
	{
		sint16 parent_id;
		mat4   transform;
	};

	struct nmd_key_channel_header
	{
		key_descriptor format;
		uint32         count;
	};

	struct nmd_stream_header
	{
		vertex_descriptor format;
		uint32 count;
	};

	class nmd_loader : public mesh_loader
	{
	public:
		nmd_loader() : m_node_data( nullptr ), m_node_array( nullptr ), m_strings( nullptr ) {}
		virtual bool load( stream& source );
		virtual mesh_data* release_mesh_data( size_t index = 0 );
		virtual mesh_nodes_data* release_mesh_nodes_data();
		virtual mesh_data_pack* release_mesh_data_pack();
		virtual size_t get_mesh_count() const { return m_meshes.size(); }
		virtual ~nmd_loader();
	private:
		void reset();
		bool load_mesh( stream& source, const nmd_element_header& e );
		bool load_strings( stream& source ); 
		bool load_animation( stream& source, const nmd_element_header& e );

		mesh_nodes_data*          m_node_data;
		mesh_node_data*           m_node_array;
		string_table*             m_strings;
		std::vector< uint16 >     m_mesh_names;
		std::vector< uint16 >     m_node_names;
		std::vector< mesh_data* > m_meshes;
	};

	// TODO: Temporary, find a better way and remove!
	class nmd_temp_model_data
	{
		friend class nmd_temp_animation_data;
	public:
		nmd_temp_model_data( nmd_loader* loader );
		const mesh_data* get_data( uint32 index ) const { return m_mesh_data[index]; }
		uint32 get_count() const { return m_mesh_data.size(); }
		const mesh_nodes_data* get_node_data() const { return m_node_data; }
		~nmd_temp_model_data();
	private:
		std::vector< mesh_data*> m_mesh_data;
		mesh_nodes_data*         m_node_data;
	};

}

#endif // NV_NMD_LOADER_HH
