// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file md5_loader.hh
 * @author Kornel Kisielewicz
 * @brief md5 loader
 */

#ifndef NV_MD5_LOADER_HH
#define NV_MD5_LOADER_HH

#include <nv/common.hh>
#include <nv/array.hh>
#include <nv/interface/mesh_loader.hh>

namespace nv 
{

	struct md5_vtx_pnt
	{
		vec3 position;
		vec3 normal;
		vec3 tangent;
	};

	struct md5_vtx_t
	{
		vec2 texcoord;
	};

	struct md5_vtx_pntiw
	{
		vec3  position;
		vec3  normal;
		vec3  tangent;
		ivec4 boneindex;
		vec4  boneweight;
	};

	class md5_animation
	{
	protected:
		friend class md5_loader;
		friend class md5_mesh_data;
		struct md5_joint_info
		{
			std::string name;
			int         parent_id;
			int         flags;
			size_t      start_index;
		};

		struct md5_joint
		{
			int                      parent;
			std::vector< transform > keys;

			md5_joint( int a_parent ) : parent( a_parent ) {}
		};

	public:
		md5_animation();
		virtual ~md5_animation();

		bool load_animation( stream& source );
		void update_skeleton( transform* skeleton, float anim_time ) const;
		
		size_t get_num_joints() const { return m_num_joints; }
		size_t get_frame_rate() const { return m_frame_rate; }
		size_t get_frame_count() const { return m_num_frames; }

	protected:
		std::vector<md5_joint>  m_joints;
		void build_frame_skeleton( const std::vector<md5_joint_info>& joint_info, const std::vector<transform>& base_frames, const std::vector<float>& frame_data );

	private:
		size_t m_md5_version;
		size_t m_num_frames;
		size_t m_num_joints;
		size_t m_frame_rate;
		size_t m_num_animated_components;
		float m_frame_duration;
		float m_anim_duration;
	};

	class md5_loader : public mesh_loader
	{
	public:
		md5_loader() {}
		virtual ~md5_loader();
		virtual bool load( stream& source );
		virtual mesh_data* release_mesh_data( size_t index = 0 );
		virtual mesh_nodes_data* release_mesh_nodes_data();
		// TODO: broken due to larger mesh_data structure!
		virtual mesh_data_pack* release_mesh_data_pack();
		virtual size_t get_mesh_count() const { return m_meshes.size(); }
	protected:
		struct md5_weight
		{
			size_t    joint_id;
			float     bias;
			glm::vec3 pos;
		};

		struct md5_weight_info
		{
			size_t     start_weight;
			size_t     weight_count;
		};

		struct md5_joint
		{
			std::string name;
			vec3  pos;
			quat  orient;
		};
	protected:
		bool prepare_mesh( uint32 vtx_count, mesh_data* mdata, md5_weight* weights, md5_weight_info* weight_info );
	protected:
		uint32 m_md5_version;
		uint32 m_num_joints;
		uint32 m_num_meshes;

		dynamic_array<md5_joint>  m_joints;
		dynamic_array<mesh_data*> m_meshes;
	};

}

#endif // NV_MD5_LOADER_HH
