// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file mesh_loader.hh
 * @author Kornel Kisielewicz
 * @brief mesh loader
 */

#ifndef NV_MESH_LOADER_HH
#define NV_MESH_LOADER_HH

#include <nv/common.hh>
#include <vector>
#include <unordered_map>
#include <nv/transform.hh>
#include <nv/string.hh>
#include <nv/gfx/animation.hh>
#include <nv/interface/mesh_data.hh>
#include <nv/interface/stream.hh>

namespace nv 
{

	// TODO: change to generic nodes!
	class tag_map
	{
	public:
		typedef std::unordered_map< std::string, uint32 > map;

		tag_map() {}

		const key_data* get_tag( uint32 id ) const
		{
			return m_data[id];
		}
		uint32 get_tag_id( const std::string& key ) const
		{
			return m_map.at( key );
		}
		void insert( const std::string& key, key_data* chan )
		{
			m_map[ key ] = m_data.size();
			m_data.push_back( chan );
		}
		~tag_map()
		{
			for ( auto t : m_data )
				delete t;
		}
	private:
		std::vector< key_data* > m_data;
		map m_map;
	};

	struct mesh_node_data
	{
		string    name;
		sint16    target_id;
		sint16    parent_id;
		mat4      transform;
		key_data* data;
	};

	class mesh_loader
	{
	public:
		mesh_loader() {}
		virtual ~mesh_loader() {}
		virtual tag_map* create_tag_map() { return nullptr; }
		virtual bool load( stream& source ) = 0;
		virtual mesh_data* release_mesh_data( size_t index = 0 ) = 0;
		virtual size_t get_mesh_count() const = 0;
		virtual mesh_node_data* release_mesh_node_data( size_t ) { return nullptr; }
		virtual size_t get_node_count() const { return 0; }
	};

}

#endif // NV_MESH_LOADER_HH

