// Copyright (C) 2014 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

// WARNING: this file is explicitly designed to fuck with your brain

#ifndef NV_INTERPOLATION_RAW_HH
#define NV_INTERPOLATION_RAW_HH

#include <nv/common.hh>
#include <nv/transform.hh>
#include <nv/math.hh>
#include <nv/interface/animation_key.hh>

namespace nv
{

	inline uint32 interpolate_raw_linear( uint32 count, float factor, const float* k1, const float* k2, float* result )
	{
		for ( uint32 i = 0; i < count; ++i )
		{
			result[i] = k1[i] + factor * (k2[i] - k1[i]); 
		}
		return count;
	}

	inline uint32 interpolate_raw_quat( float factor, const float* k1, const float* k2, float* result )
	{
		*((quat*)(result)) = interpolate( *((quat*)(k1)), *((quat*)(k2)), factor );
		return 4;
	}

	inline uint32 interpolate_raw( const key_descriptor_slot& slot, float factor, const float* k1, const float* k2, float* result )
	{
		uint32 count = get_datatype_info( slot.etype ).elements;
		switch ( slot.vslot )
		{
		case animation_slot::TIME:     return 0;
		case animation_slot::POSITION: return interpolate_raw_linear( count, factor, k1, k2, result );
		case animation_slot::ROTATION: return interpolate_raw_quat( factor, k1, k2, result );
		case animation_slot::SCALE:    return interpolate_raw_linear( count, factor, k1, k2, result );
		case animation_slot::TFORM:    return 
										   interpolate_raw_linear( 3, factor, k1, k2, result ) + 
										   interpolate_raw_quat( factor, k1 + 3, k2 + 3, result + 3 );
		default:
			return 0;
		};
	}

	inline quat make_quat_fixed( const float* data )
	{
		quat result;
		memcpy((float*)(&result), data, sizeof(quat));
		return result;
	}

	inline mat4 extract_matrix_raw( const key_descriptor& desc, const float* data )
	{
		if ( desc.count == 1 )
		{
			switch ( desc.slots[0].vslot )
			{
			case animation_slot::TIME:     return mat4();
			case animation_slot::POSITION: return glm::translate( mat4(),glm::make_vec3( data ) );
			case animation_slot::ROTATION: return glm::mat4_cast( make_quat_fixed( data ) );
			case animation_slot::SCALE:    return glm::scale( mat4(),glm::make_vec3( data ) );
			case animation_slot::TFORM:    return transform( glm::make_vec3( data ), make_quat_fixed( data + 3 ) ).extract();
			default:
				return mat4();
			};
		}
		else
		{
			mat4 position;
			mat4 rotation;
			mat4 scale;
			for ( uint32 i = 0; i < desc.count; ++i )
			{
				uint32 offset = desc.slots[i].offset / 4;
				switch ( desc.slots[i].vslot )
				{
				case animation_slot::TIME:     break;
				case animation_slot::POSITION: 
					position = glm::translate( position,glm::make_vec3( data + offset ) ); break;
				case animation_slot::ROTATION: 
					rotation = glm::mat4_cast( make_quat_fixed( data + offset ) ); break;
				case animation_slot::SCALE:    
					scale    = glm::scale( mat4(),glm::make_vec3( data + offset ) ); break;
				case animation_slot::TFORM:    return transform( glm::make_vec3( data + offset ), make_quat_fixed( data + offset + 3 ) ).extract();
				default:
					break;
				}
			}
			return position * rotation * scale;
		}
	}

	inline transform extract_transform_raw( const key_descriptor& desc, const float* data )
	{
		if ( desc.count == 1 )
		{
			switch ( desc.slots[0].vslot )
			{
			case animation_slot::TIME:     return transform();
			case animation_slot::POSITION: return transform( glm::make_vec3( data ) );
			case animation_slot::ROTATION: return transform( make_quat_fixed( data ) );
			case animation_slot::SCALE:    return transform();
			case animation_slot::TFORM:    return transform( glm::make_vec3( data ), make_quat_fixed( data + 3 ) );
			default:
				return transform();
			};
		}
		else
		{
			vec3 position;
			quat rotation;
			for ( uint32 i = 0; i < desc.count; ++i )
			{
				uint32 offset = desc.slots[i].offset / 4;
				switch ( desc.slots[i].vslot )
				{
				case animation_slot::TIME:     break;
				case animation_slot::POSITION: 
					position = glm::make_vec3( data + offset ); break;
				case animation_slot::ROTATION: 
					rotation = make_quat_fixed( data + offset ); break;
				case animation_slot::SCALE:	   break;
				case animation_slot::TFORM:    return transform( glm::make_vec3( data + offset ), make_quat_fixed( data + 3 ) );
				default:
					break;
				}
			}
			return transform( position, rotation );
		}
	}


}

#endif // NV_INTERPOLATION_RAW_HH
