// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_KEYFRAMED_MESH_HH
#define NV_KEYFRAMED_MESH_HH

#include <nv/common.hh>
#include <nv/interface/context.hh>
#include <nv/interface/animated_mesh.hh>
#include <nv/formats/md3_loader.hh>

namespace nv
{

	class keyframed_animation_entry : public animation_entry
	{
	public:
		friend class keyframed_mesh;

		keyframed_animation_entry( const std::string& name, uint32 a_start, uint32 a_frames, uint32 a_fps, bool a_loop )
			: animation_entry( name ), m_start( a_start ), m_frames( a_frames ), m_fps( a_fps ), m_looping( a_loop ) {}
		virtual uint32 get_frame_rate() const { return m_fps; }
		virtual uint32 get_frame_count() const { return m_frames; }
		virtual bool is_looping() const { return m_looping; }
	protected:
		uint32 m_start;
		uint32 m_frames;
		uint32 m_fps;
		bool   m_looping;
	};


	class keyframed_mesh : public animated_mesh
	{
	public:
		keyframed_mesh( device* a_device, mesh_data* a_data, tag_map* a_tag_map );
		virtual size_t get_index_count() const { return m_index_count; }
		virtual void run_animation( animation_entry* a_anim );
		size_t get_max_frames() const;
		transform get_tag( uint32 tag_id ) const;
		virtual void setup_animation( uint32 start, uint32 count, uint32 fps, bool loop );
		virtual void set_frame( uint32 frame );
		virtual void update_animation( animation_entry*, uint32 a_anim_time );
		virtual void update( program* a_program ) const;
		virtual ~keyframed_mesh();
	protected:
		struct vertex_pn
		{
			vec3 position;
			vec3 normal;
		};
		struct vertex_t
		{
			vec2 texcoord;
		};

		mesh_data* m_mesh_data;
		tag_map*   m_tag_map;

		uint32 m_start_frame;
		uint32 m_stop_frame;
		uint32 m_last_frame;
		uint32 m_next_frame;
		uint32 m_fps;
		f32    m_interpolation;
		bool   m_looping;
		bool   m_active;

		uint32 m_index_count;
		uint32 m_frame_count;
		uint32 m_vertex_count;
	};


	class keyframed_mesh_gpu : public keyframed_mesh
	{
	public:
		keyframed_mesh_gpu( device* a_device, mesh_data* a_data, tag_map* a_tag_map, program* a_program );
		void update( uint32 ms );
	private:
		int m_loc_next_position;
		int m_loc_next_normal;

		uint32 m_gpu_last_frame;
		uint32 m_gpu_next_frame;
	};

	class keyframed_mesh_cpu : public keyframed_mesh
	{
	public:
		keyframed_mesh_cpu( device* a_device, mesh_data* a_data, tag_map* a_tag_map );
		void update( uint32 ms );
	private:
		std::vector<vertex_pn> m_vertex;
		vertex_buffer*         m_vb;
	};

} // namespace nv

#endif // NV_KEYFRAMED_MESH_HH
