/* SDL.h functions */
NV_SDL_FUN( int, SDL_Init, (Uint32 flags) );
NV_SDL_FUN( int, SDL_InitSubSystem, (Uint32 flags) );
NV_SDL_FUN( void, SDL_QuitSubSystem, (Uint32 flags) );
NV_SDL_FUN( Uint32, SDL_WasInit, (Uint32 flags) );
NV_SDL_FUN( void, SDL_Quit, (void) );

/* SDL_rwops.h functions */
NV_SDL_FUN( SDL_RWops *, SDL_RWFromFile, (const char *file, const char *mode) );
NV_SDL_FUN( SDL_RWops *, SDL_RWFromFP, (FILE *fp, SDL_bool autoclose) );
NV_SDL_FUN( SDL_RWops *, SDL_RWFromMem, (void *mem, int size) );
NV_SDL_FUN( SDL_RWops *, SDL_RWFromConstMem, (const void *mem, int size) );
NV_SDL_FUN( SDL_RWops *, SDL_AllocRW, (void) );
NV_SDL_FUN( void, SDL_FreeRW, (SDL_RWops *area) );
NV_SDL_FUN( Uint16, SDL_ReadLE16, (SDL_RWops *src) );
NV_SDL_FUN( Uint16, SDL_ReadBE16, (SDL_RWops *src) );
NV_SDL_FUN( Uint32, SDL_ReadLE32, (SDL_RWops *src) );
NV_SDL_FUN( Uint32, SDL_ReadBE32, (SDL_RWops *src) );
NV_SDL_FUN( Uint64, SDL_ReadLE64, (SDL_RWops *src) );
NV_SDL_FUN( Uint64, SDL_ReadBE64, (SDL_RWops *src) );
NV_SDL_FUN( int, SDL_WriteLE16, (SDL_RWops *dst, Uint16 value) );
NV_SDL_FUN( int, SDL_WriteBE16, (SDL_RWops *dst, Uint16 value) );
NV_SDL_FUN( int, SDL_WriteLE32, (SDL_RWops *dst, Uint32 value) );
NV_SDL_FUN( int, SDL_WriteBE32, (SDL_RWops *dst, Uint32 value) );
NV_SDL_FUN( int, SDL_WriteLE64, (SDL_RWops *dst, Uint64 value) );
NV_SDL_FUN( int, SDL_WriteBE64, (SDL_RWops *dst, Uint64 value) );

/* SDL_audio.h functions */
NV_SDL_FUN( int, SDL_AudioInit, (const char *driver_name) );
NV_SDL_FUN( void, SDL_AudioQuit, (void) ); 
NV_SDL_FUN( int, SDL_OpenAudio, (SDL_AudioSpec *desired, SDL_AudioSpec *obtained) );
NV_SDL_FUN( SDL_audiostatus, SDL_GetAudioStatus, (void) );
NV_SDL_FUN( void, SDL_PauseAudio, (int pause_on) );
NV_SDL_FUN( SDL_AudioSpec *, SDL_LoadWAV_RW, (SDL_RWops *src, int freesrc, SDL_AudioSpec *spec, Uint8 **audio_buf, Uint32 *audio_len) );
NV_SDL_FUN( void, SDL_FreeWAV, (Uint8 *audio_buf) );
NV_SDL_FUN( int, SDL_BuildAudioCVT, (SDL_AudioCVT *cvt, SDL_AudioFormat src_format, Uint8 src_channels, int src_rate, SDL_AudioFormat dst_format, Uint8 dst_channels, int dst_rate) );
NV_SDL_FUN( int, SDL_ConvertAudio, (SDL_AudioCVT *cvt) );
NV_SDL_FUN( void, SDL_MixAudio, (Uint8 *dst, const Uint8 *src, Uint32 len, int volume) );
NV_SDL_FUN( void, SDL_LockAudio, (void) );
NV_SDL_FUN( void, SDL_UnlockAudio, (void) );
NV_SDL_FUN( void, SDL_CloseAudio, (void) );  

/* SDL_cpuinfo.h functions */
NV_SDL_FUN( SDL_bool, SDL_HasRDTSC, (void) );
NV_SDL_FUN( SDL_bool, SDL_HasMMX, (void) );
NV_SDL_FUN( SDL_bool, SDL_Has3DNow, (void) );
NV_SDL_FUN( SDL_bool, SDL_HasSSE, (void) );
NV_SDL_FUN( SDL_bool, SDL_HasSSE2, (void) );
NV_SDL_FUN( SDL_bool, SDL_HasAltiVec, (void) ); 

/* SDL_error.h functions */
NV_SDL_FUN( char *, SDL_GetError, (void) );
NV_SDL_FUN( void, SDL_ClearError, (void) );

/* SDL_mouse.h functions */
NV_SDL_FUN( void, SDL_SetCursor, (SDL_Cursor *cursor) );
NV_SDL_FUN( SDL_Cursor *, SDL_GetCursor, (void) );
NV_SDL_FUN( void, SDL_FreeCursor, (SDL_Cursor *cursor) );
NV_SDL_FUN( int, SDL_ShowCursor, (int toggle) );

/* SDL_joystick.h functions */
NV_SDL_FUN( int, SDL_NumJoysticks, (void) );
NV_SDL_FUN( int, SDL_JoystickNumAxes, (SDL_Joystick *joystick) );
NV_SDL_FUN( int, SDL_JoystickNumBalls, (SDL_Joystick *joystick) );
NV_SDL_FUN( int, SDL_JoystickNumHats, (SDL_Joystick *joystick) );
NV_SDL_FUN( int, SDL_JoystickNumButtons, (SDL_Joystick *joystick) );
NV_SDL_FUN( void, SDL_JoystickUpdate, (void) );
NV_SDL_FUN( SDL_Joystick *, SDL_JoystickOpen, (int device_index) );
NV_SDL_FUN( int, SDL_JoystickEventState, (int state) );
NV_SDL_FUN( Sint16, SDL_JoystickGetAxis, (SDL_Joystick *joystick, int axis) );
NV_SDL_FUN( Uint8, SDL_JoystickGetHat, (SDL_Joystick *joystick, int hat) );
NV_SDL_FUN( int, SDL_JoystickGetBall, (SDL_Joystick *joystick, int ball, int *dx, int *dy) );
NV_SDL_FUN( Uint8, SDL_JoystickGetButton, (SDL_Joystick *joystick, int button) );
NV_SDL_FUN( void, SDL_JoystickClose, (SDL_Joystick *joystick) );

/* SDL_timer.h functions */
NV_SDL_FUN( Uint32, SDL_GetTicks, (void) );
NV_SDL_FUN( void, SDL_Delay, (Uint32 ms) );
NV_SDL_FUN( SDL_TimerID, SDL_AddTimer, (Uint32 interval, SDL_TimerCallback callback, void *param) );
NV_SDL_FUN( SDL_bool, SDL_RemoveTimer, (SDL_TimerID t) );

/* SDL_event.h functions */
NV_SDL_FUN( void, SDL_PumpEvents, (void) );
NV_SDL_FUN( int, SDL_PollEvent, (SDL_Event *event) );
NV_SDL_FUN( int, SDL_WaitEvent, (SDL_Event *event) );
NV_SDL_FUN( int, SDL_PushEvent, (SDL_Event *event) );

/* SDL_video/SDL_surface */
NV_SDL_FUN( SDL_Surface *, SDL_CreateRGBSurface, (Uint32 flags, int width, int height, int depth, Uint32 Rmask, Uint32 Gmask, Uint32 Bmask, Uint32 Amask) );
NV_SDL_FUN( SDL_Surface *, SDL_CreateRGBSurfaceFrom, (void *pixels, int width, int height, int depth, int pitch, Uint32 Rmask, Uint32 Gmask, Uint32 Bmask, Uint32 Amask) );
NV_SDL_FUN( void , SDL_FreeSurface, (SDL_Surface * surface) );
NV_SDL_FUN( int , SDL_LockSurface, (SDL_Surface * surface) );
NV_SDL_FUN( void , SDL_UnlockSurface, (SDL_Surface * surface) );
NV_SDL_FUN( int, SDL_SaveBMP_RW, (SDL_Surface *surface, SDL_RWops *dst, int freedst) );
NV_SDL_FUN( SDL_Surface *, SDL_LoadBMP_RW, (SDL_RWops *src, int freesrc) );
NV_SDL_FUN( SDL_bool , SDL_SetClipRect, (SDL_Surface * surface,const SDL_Rect * rect) );
NV_SDL_FUN( void , SDL_GetClipRect, (SDL_Surface * surface,SDL_Rect * rect) );
NV_SDL_FUN( SDL_Surface *, SDL_ConvertSurface, (SDL_Surface *src, SDL_PixelFormat *fmt, Uint32 flags) );

NV_SDL_FUN( int , SDL_GL_LoadLibrary, (const char *path) );
NV_SDL_FUN( void *, SDL_GL_GetProcAddress, (const char *proc) );
NV_SDL_FUN( int, SDL_GL_SetAttribute, (SDL_GLattr attr, int value) );
NV_SDL_FUN( int, SDL_GL_GetAttribute, (SDL_GLattr attr, int* value) );

