// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/common.hh"
#include "nv/lib/gl.hh"

#if defined( NV_GL_DYNAMIC )

#include "nv/library.hh"

#if defined( NV_SDL_GL )
#	include "nv/lib/sdl.hh"
#endif

// for wgl support
#if NV_PLATFORM == NV_WINDOWS
#    ifndef WIN32_LEAN_AND_MEAN
#      define WIN32_LEAN_AND_MEAN 1
#    endif
#include <windows.h>
#    undef WIN32_LEAN_AND_MEAN
#endif

// extern added for wgl needs only!
#define NV_GL_FUN( rtype, fname, fparams ) extern "C" rtype (NV_GL_APIENTRY *fname) fparams = nullptr;
#define NV_GL_FUN_REN( rtype, fname, rname, fparams ) extern "C" rtype (NV_GL_APIENTRY *rname) fparams = nullptr;
#define NV_GL_FUN_EXT NV_GL_FUN
#include <nv/lib/detail/gl_functions.inc>
#if NV_PLATFORM == NV_WINDOWS
#include <nv/lib/detail/wgl_functions.inc>
#endif
#undef NV_GL_FUN_REN
#undef NV_GL_FUN_EXT
#undef NV_GL_FUN

static nv::library gl_library;
static bool gl_library_loaded = false;
static bool wgl_library_loaded = false;

bool nv::load_gl_library( const char* path )
{
	if ( gl_library_loaded ) return true;
#if defined( NV_SDL_GL )
#		define NV_GL_LOAD( symbol ) *(void **) (&symbol) = SDL_GL_GetProcAddress(#symbol);
#		define NV_GL_LOAD_EXT( symbol ) *(void **) (&symbol) = SDL_GL_GetProcAddress(#symbol);
#else
	if ( !gl_library.is_open() ) gl_library.open( path );

	void * (NV_GL_APIENTRY *ext_loader) (const char* proc) = nullptr;
#	if NV_PLATFORM == NV_WINDOWS 
#		define NV_GL_LOAD( symbol ) *(void **) (&symbol) = gl_library.get(#symbol);
		*(void **) (&ext_loader) = gl_library.get("wglGetProcAddress");
#		define NV_GL_LOAD_EXT( symbol ) *(void **) (&symbol) = ext_loader(#symbol);
#	elif (NV_PLATFORM == NV_LINUX || NV_PLATFORM == NV_APPLE)
#		define NV_GL_LOAD( symbol ) *(void **) (&symbol) = gl_library.get(#symbol);
		*(void **) (&ext_loader) = gl_library.get("glXGetProcAddress");
#		define NV_GL_LOAD_EXT( symbol ) *(void **) (&symbol) = ext_loader(#symbol);
#	else
#		define NV_GL_LOAD( symbol ) *(void **) (&symbol) = gl_library.get(#symbol);
#		define NV_GL_LOAD_EXT( symbol ) *(void **) (&symbol) = gl_library.get(#symbol);
#	endif
#endif

#	define NV_GL_FUN( rtype, fname, fparams ) NV_GL_LOAD( fname )
#	define NV_GL_FUN_EXT( rtype, fname, fparams ) NV_GL_LOAD_EXT( fname )
#	include <nv/lib/detail/gl_functions.inc>
#	undef NV_GL_FUN_EXT
#	undef NV_GL_FUN

#	undef NV_GL_LOAD
#	undef NV_GL_LOAD_EXT
	gl_library_loaded = true;
	return true;
}

bool nv::load_wgl_library( const char* path /*= NV_GL_PATH */ )
{
	if ( wgl_library_loaded ) return true;
#if NV_PLATFORM == NV_WINDOWS 
#if defined( NV_SDL_GL )
#		define NV_GL_LOAD( symbol ) *(void **) (&symbol) = SDL_GL_GetProcAddress(#symbol);
#		define NV_GL_LOAD_EXT( symbol ) *(void **) (&symbol) = SDL_GL_GetProcAddress(#symbol);
#	    define NV_GL_LOAD_REN( fname, rname )  *(void **) (&rname) = SDL_GL_GetProcAddress(#fname);
#else // 
	if ( !gl_library.is_open() ) gl_library.open( path );

	void * (NV_GL_APIENTRY *ext_loader) (const char* proc) = nullptr;
	*(void **) (&ext_loader) = gl_library.get("wglGetProcAddress");
#define NV_GL_LOAD( symbol ) *(void **) (&symbol) = gl_library.get(#symbol);
#define NV_GL_LOAD_EXT( symbol ) *(void **) (&symbol) = ext_loader(#symbol);
#define NV_GL_LOAD_REN( fname, rname ) *(void **) (&rname) = gl_library.get(#fname);
#endif 
#	define NV_GL_FUN( rtype, fname, fparams ) NV_GL_LOAD( fname )
#	define NV_GL_FUN_EXT( rtype, fname, fparams ) NV_GL_LOAD_EXT( fname )
#	define NV_GL_FUN_REN( rtype, fname, rname, fparams ) NV_GL_LOAD_REN( fname, rname )
#	include <nv/lib/detail/wgl_functions.inc>
#	undef NV_GL_FUN_REN
#	undef NV_GL_FUN_EXT
#	undef NV_GL_FUN

#	undef NV_GL_LOAD
#	undef NV_GL_LOAD_EXT
#	undef NV_GL_LOAD_REN
	wgl_library_loaded = true;
	return true;
#else
	return false;
#endif
}

#endif // NV_DYNAMIC

bool nv::load_gl_no_context( const char* path /*= NV_GL_PATH */ )
{
#if NV_PLATFORM == NV_WINDOWS 
	if ( !gl_library.is_open() ) gl_library.open( path );
	if ( wgl_library_loaded ) return true;

	HGLRC (NV_GL_APIENTRY *wgl_createcontext) (HDC)        = nullptr;
	BOOL  (NV_GL_APIENTRY *wgl_makecurrent)   (HDC, HGLRC) = nullptr;
	BOOL  (NV_GL_APIENTRY *wgl_deletecontext) (HGLRC)      = nullptr;

	*(void **) &wgl_createcontext = gl_library.get("wglCreateContext");
	*(void **) &wgl_makecurrent   = gl_library.get("wglMakeCurrent");
	*(void **) &wgl_deletecontext = gl_library.get("wglDeleteContext");

	WNDCLASS wndClass;
	HINSTANCE hInstance = 0;

	ZeroMemory(&wndClass, sizeof(WNDCLASS));

	wndClass.cbClsExtra = 0;
	wndClass.cbWndExtra = 0;			
	wndClass.hCursor = LoadCursor(NULL, IDC_ARROW);
	wndClass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wndClass.hInstance = hInstance;
	wndClass.lpfnWndProc = (WNDPROC) DefWindowProc;
	wndClass.lpszClassName = TEXT("Dummy67789");
	wndClass.lpszMenuName = 0;
	wndClass.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;

	DWORD err = GetLastError();
	RegisterClass(&wndClass);
	err = GetLastError();


	HWND hWndFake = CreateWindow(TEXT("Dummy67789"), "FAKE", WS_OVERLAPPEDWINDOW | WS_MAXIMIZE | WS_CLIPCHILDREN, 
		0, 0, CW_USEDEFAULT, CW_USEDEFAULT, NULL, 
		NULL, GetModuleHandle(nullptr), NULL); 

	HDC hDC = GetDC(hWndFake); 

	PIXELFORMATDESCRIPTOR pfd; 
	memset(&pfd, 0, sizeof(PIXELFORMATDESCRIPTOR)); 
	pfd.nSize= sizeof(PIXELFORMATDESCRIPTOR); 
	pfd.nVersion   = 1; 
	pfd.dwFlags    = PFD_DOUBLEBUFFER | PFD_SUPPORT_OPENGL | PFD_DRAW_TO_WINDOW; 
	pfd.iPixelType = PFD_TYPE_RGBA; 
	pfd.cColorBits = 32; 
	pfd.cDepthBits = 24; 
	pfd.iLayerType = PFD_MAIN_PLANE; 

	int iPixelFormat = ChoosePixelFormat(hDC, &pfd); 
	if (iPixelFormat == 0)return false; 

	if(!SetPixelFormat(hDC, iPixelFormat, &pfd))return false; 

	HGLRC hRCFake = wgl_createcontext(hDC); 
	wgl_makecurrent(hDC, hRCFake); 

	LoadLibrary( "gdi32.dll" );
	bool gl_loaded = nv::load_gl_library( path );
	bool wgl_loaded = nv::load_wgl_library( path );
	bool result = gl_loaded && wgl_loaded;

	wgl_makecurrent(NULL, NULL); 
	wgl_deletecontext(hRCFake); 
	DestroyWindow(hWndFake); 
	return result;
#else
	return false;
#endif
}

