// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file mesh_loader.hh
 * @author Kornel Kisielewicz
 * @brief mesh loader
 */

#ifndef NV_MESH_LOADER_HH
#define NV_MESH_LOADER_HH

#include <nv/common.hh>
#include <vector>
#include <unordered_map>
#include <nv/transform.hh>
#include <nv/string.hh>
#include <nv/gfx/animation.hh>
#include <nv/interface/mesh_data.hh>
#include <nv/interface/stream.hh>

namespace nv 
{

	// TODO: change to generic nodes!
	class tag_map
	{
	public:
		typedef std::unordered_map< std::string, key_raw_channel* > map;

		tag_map () {}

		const transform* get_tag( const std::string& key ) const
		{
			key_raw_channel* channel = m_map.at( key );
			return ((transform*)(channel->data));
		}
		void insert( const std::string& key, key_raw_channel* chan )
		{
			m_map[ key ] = chan;
		}
		~tag_map()
		{
			for ( auto t : m_map )
				delete t.second;
		}
	private:
		map m_map;
	};


	class mesh_loader
	{
	public:
		mesh_loader() {}
		virtual ~mesh_loader() {}
		virtual tag_map* create_tag_map() { return nullptr; }
		virtual bool load( stream& source ) = 0;
		virtual mesh_data* release_mesh_data( size_t index = 0 ) = 0;
		virtual size_t get_mesh_count() const = 0;
	};

}

#endif // NV_MESH_LOADER_HH

