// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file md3_loader.hh
 * @author Kornel Kisielewicz
 * @brief md3 loader
 */

#ifndef NV_MD3_LOADER_HH
#define NV_MD3_LOADER_HH

#include <nv/common.hh>
#include <unordered_map>
#include <vector>
#include <nv/transform.hh>
#include <nv/interface/mesh_data.hh>
#include <nv/interface/mesh_loader.hh>

namespace nv 
{
	struct md3_key
	{
		transform tform;
	};


	class md3_loader : public mesh_loader
	{
	public:
		md3_loader();
		virtual ~md3_loader();
		virtual bool load( stream& source );
		virtual mesh_data* release_mesh_data( size_t index = 0 );
		virtual mesh_data* release_mesh_frame( sint32 frame );
		virtual size_t get_mesh_count() const { return 1; }
		size_t get_max_frames() const;
		virtual tag_map* create_tag_map();
	private:
		key_raw_channel* load_tags( const std::string& tag );
		void* m_md3;
	};

}

#endif // NV_OBJ_LOADER_HH
