// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file exception.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief nv exception bases
 */

#ifndef NV_EXCEPTION_HH
#define NV_EXCEPTION_HH

#include <nv/common.hh>
#include <string>
#include <exception>
#include <stdexcept>

namespace nv
{
	/**
	 * NV logic_error.
	 *
	 * Inherits std::logic_error.
	 */
	class logic_error : public std::logic_error
	{
	public:
		explicit logic_error( const std::string& msg ) : std::logic_error( msg ) {}
	};

	/**
	 * NV runtime_error.
	 *
	 * Inherits std::runtime_error.
	 */
	class runtime_error : public std::runtime_error
	{
	public:
		explicit runtime_error( const std::string& msg ) : std::runtime_error( msg ) {}
	};
}

#endif // NV_EXCEPTION_HH
