// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/root.hh"

#include "nv/uid.hh"
#include "nv/lua/lua_state.hh"

void nv::root::destroy_object( object* o )
{
	destroy_children( o );
	o->detach();
	delete o;
}

void nv::root::destroy_children( object* o )
{
	while ( !o->m_children.empty() )
	{
		destroy_object( o->m_children.front() );
	}
}
