// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_SKELETAL_MESH_HH
#define NV_SKELETAL_MESH_HH

#include <nv/common.hh>
#include <nv/interface/context.hh>
#include <nv/interface/animated_mesh.hh>
#include <nv/formats/md5_loader.hh>
#include <nv/formats/nmd_loader.hh>

namespace nv
{

	class skeletal_animation_entry : public animation_entry
	{
	public:
		friend class skeletal_mesh;

		skeletal_animation_entry( const std::string& name, md5_animation* a_animation, bool a_looping ) 
			: animation_entry( name ), m_animation( a_animation ), m_looping( a_looping ) {}
		virtual uint32 get_frame_rate() const { return m_animation->get_frame_rate(); }
		virtual uint32 get_frame_count() const { return m_animation->get_frame_count(); }
		virtual bool is_looping() const { return m_looping; }
		uint32 get_num_joints() const { return m_animation->get_num_joints();}
		void update_skeleton( transform* tr, float time ) const { return m_animation->update_skeleton( tr, time );}
	protected:
		md5_animation* m_animation;
		bool           m_looping;
	};

	class skeletal_mesh : public animated_mesh
	{
	public:
		skeletal_mesh( device* a_device, md5_mesh_data* a_mesh_data );
		virtual size_t get_index_count() const { return m_mesh_data->get_index_count(); }
		virtual void run_animation( animation_entry* a_anim );
		virtual void update_animation( animation_entry* a_anim, uint32 a_anim_time );
		virtual ~skeletal_mesh();
	protected:
		md5_mesh_instance* m_mesh_data;
		std::vector< transform > m_transform;
	};

 	class skeletal_animation_entry_gpu : public animation_entry
 	{
 	public:
 		skeletal_animation_entry_gpu( const std::string& name, nmd_temp_animation* anim, bool a_looping ) 
 			: animation_entry( name ), m_animation( anim ), m_looping( a_looping ), m_prepared( false ) {}
 		virtual uint32 get_frame_rate() const { return 0; }
 		virtual uint32 get_frame_count() const { return 0; }
 		virtual bool is_looping() const { return m_looping; }
		void prepare( const nmd_temp_model* m_model );
		void update_skeleton( mat4* tr, uint32 time );
 	protected:
 		nmd_temp_animation* m_animation;
		bool           m_prepared;
 		bool           m_looping;
 	};

	class skeletal_mesh_gpu : public animated_mesh
	{
	public:
		skeletal_mesh_gpu( device* a_device, const nmd_temp_model* a_model, uint32 index, bool primary );
		virtual size_t get_index_count() const { return m_index_count; }
		virtual void run_animation( animation_entry* a_anim );
		virtual void update( program* a_program ) const;
		virtual void update_animation( animation_entry* a_anim, uint32 
			a_anim_time );
	protected:
		const nmd_temp_model* m_model;
		bool m_primary;
		uint32 m_index_count;
		std::vector< mat4 > m_transform;
	};

} // namespace nv

#endif // NV_SKELETAL_MESH_HH
